/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.cinderhearth;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.GatedStackPastelRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CinderhearthRecipe
extends GatedStackPastelRecipe<SingleRecipeInput> {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("unlocks/blocks/cinderhearth");
    protected final IngredientStack ingredient;
    protected final int time;
    protected final float experience;
    protected final List<Tuple<ItemStack, Float>> resultsWithChance;

    public CinderhearthRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, IngredientStack ingredient, int time, float experience, List<Tuple<ItemStack, Float>> resultsWithChance) {
        super(group, secret, requiredAdvancementIdentifier);
        this.ingredient = ingredient;
        this.time = time;
        this.experience = experience;
        this.resultsWithChance = resultsWithChance;
        this.registerInToastManager(this.getType(), this);
    }

    public boolean matches(SingleRecipeInput input, Level world) {
        return this.ingredient.test(input.getItem(0));
    }

    @Deprecated
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registryLookup) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryLookup) {
        return (ItemStack)this.resultsWithChance.getFirst().getA();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.CINDERHEARTH.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.CINDERHEARTH_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.CINDERHEARTH;
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "cinderhearth";
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return List.of(this.ingredient);
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCraftingTime() {
        return this.time;
    }

    public List<ItemStack> getRolledOutputs(RandomSource random, float yieldMod) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (Tuple<ItemStack, Float> possibleOutput : this.resultsWithChance) {
            float chance = ((Float)possibleOutput.getB()).floatValue();
            if (!((double)chance >= 1.0) && !(random.nextFloat() < chance * yieldMod)) continue;
            ItemStack currentOutputStack = (ItemStack)possibleOutput.getA();
            if (yieldMod > 1.0f) {
                int count;
                for (int totalCount = Support.chanceRound((float)currentOutputStack.getCount() * yieldMod, random); totalCount > 0; totalCount -= count) {
                    count = Math.min(totalCount, currentOutputStack.getMaxStackSize());
                    ItemStack outputStack = currentOutputStack.copy();
                    outputStack.setCount(count);
                    output.add(outputStack);
                }
                continue;
            }
            output.add(currentOutputStack.copy());
        }
        return output;
    }

    public List<ItemStack> getPossibleOutputs() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (Tuple<ItemStack, Float> pair : this.resultsWithChance) {
            outputs.add((ItemStack)pair.getA());
        }
        return outputs;
    }

    public List<Tuple<ItemStack, Float>> getResultsWithChance() {
        return this.resultsWithChance;
    }

    public static class Serializer
    implements RecipeSerializer<CinderhearthRecipe> {
        public static final MapCodec<CinderhearthRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.INT.fieldOf("time").forGetter(recipe -> recipe.time), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.withAlternative((Codec)ItemStack.CODEC.xmap(stack -> new Tuple(stack, (Object)Float.valueOf(1.0f)), Tuple::getA), (Codec)CodecHelper.mapPair(ItemStack.CODEC.fieldOf("result"), Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f))).codec()).listOf().fieldOf("results").forGetter(recipe -> recipe.resultsWithChance)).apply((Applicative)i, CinderhearthRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CinderhearthRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, ByteBufCodecs.BOOL, recipe -> recipe.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, IngredientStack.STREAM_CODEC, recipe -> recipe.ingredient, ByteBufCodecs.VAR_INT, recipe -> recipe.time, ByteBufCodecs.FLOAT, recipe -> Float.valueOf(recipe.experience), PacketCodecHelper.pair(ItemStack.STREAM_CODEC, ByteBufCodecs.FLOAT).apply(ByteBufCodecs.list()), recipe -> recipe.resultsWithChance, CinderhearthRecipe::new);

        public MapCodec<CinderhearthRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CinderhearthRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

