/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public abstract class GatedStackPastelRecipe<C extends RecipeInput>
extends GatedPastelRecipe<C> {
    protected GatedStackPastelRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier) {
        super(group, secret, requiredAdvancementIdentifier);
    }

    public abstract List<IngredientStack> getIngredientStacks();

    protected boolean matchIngredientStacksExclusively(RecipeInput recipeInput, List<IngredientStack> ingredientStacks) {
        if (recipeInput.size() < ingredientStacks.size()) {
            return false;
        }
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack stack = recipeInput.getItem(i);
            if (stack.isEmpty()) continue;
            nonEmptyStacks.add(stack);
        }
        if (nonEmptyStacks.size() != ingredientStacks.size()) {
            return false;
        }
        ObjectArraySet ingredients = ObjectArraySet.of((Object[])ingredientStacks.toArray(new IngredientStack[0]));
        for (ItemStack stack : nonEmptyStacks) {
            IngredientStack foundStack = null;
            for (IngredientStack ingredientStack : ingredients) {
                if (!ingredientStack.test(stack)) continue;
                foundStack = ingredientStack;
                break;
            }
            if (foundStack == null) {
                return false;
            }
            ingredients.remove(foundStack);
            if (!ingredients.isEmpty()) continue;
            break;
        }
        return true;
    }

    protected boolean matchIngredientStacksExclusively(RecipeInput recipeInput, List<IngredientStack> ingredients, int[] slots) {
        int inputStackCount = 0;
        for (int slot : slots) {
            if (recipeInput.getItem(slot).isEmpty()) continue;
            ++inputStackCount;
        }
        if (inputStackCount != ingredients.size()) {
            return false;
        }
        Object object = ingredients.iterator();
        while (object.hasNext()) {
            IngredientStack ingredient = (IngredientStack)object.next();
            boolean found = false;
            for (int slot : slots) {
                if (!ingredient.test(recipeInput.getItem(slot))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

