/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.toast;

import earth.terrarium.pastel.PastelCommon;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RevelationToast
implements Toast {
    private final ResourceLocation TEXTURE = PastelCommon.locate("textures/gui/toasts.png");
    private final ItemStack itemStack;
    private final SoundEvent soundEvent;
    private boolean soundPlayed;

    public RevelationToast(ItemStack itemStack, SoundEvent soundEvent) {
        this.itemStack = itemStack;
        this.soundEvent = soundEvent;
        this.soundPlayed = false;
    }

    public static void showRevelationToast(Minecraft client, ItemStack itemStack, SoundEvent soundEvent) {
        client.getToasts().addToast((Toast)new RevelationToast(itemStack, soundEvent));
    }

    public Toast.Visibility render(GuiGraphics drawContext, ToastComponent manager, long startTime) {
        MutableComponent title = Component.translatable((String)"pastel.toast.revelation.title");
        MutableComponent text = Component.translatable((String)"pastel.toast.revelation.text");
        Minecraft client = manager.getMinecraft();
        Font textRenderer = client.font;
        drawContext.blit(this.TEXTURE, 0, 0, 0, 0, this.width(), this.height());
        List wrappedText = textRenderer.split((FormattedText)text, 125);
        List wrappedTitle = textRenderer.split((FormattedText)title, 125);
        long toastTimeMilliseconds = PastelCommon.CONFIG.ToastTimeMilliseconds;
        if (startTime < toastTimeMilliseconds / 2L) {
            int l = Mth.floor((float)(Mth.clamp((float)((float)(toastTimeMilliseconds / 2L - startTime) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            int halfHeight = this.height() / 2;
            int titleSize = wrappedTitle.size();
            int m = halfHeight - titleSize * 9 / 2;
            for (FormattedCharSequence orderedText : wrappedTitle) {
                drawContext.drawString(textRenderer, orderedText, 30, m, 0x323232 | l, false);
                m += 9;
            }
        } else {
            int l = Mth.floor((float)(Mth.clamp((float)((float)(startTime - toastTimeMilliseconds / 2L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int halfHeight = this.height() / 2;
            int textSize = wrappedText.size();
            int m = halfHeight - textSize * 9 / 2;
            for (FormattedCharSequence orderedText : wrappedText) {
                drawContext.drawString(textRenderer, orderedText, 30, m, l, false);
                m += 9;
            }
        }
        if (!this.soundPlayed && startTime > 0L) {
            this.soundPlayed = true;
            if (this.soundEvent != null) {
                manager.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.soundEvent, (float)1.0f, (float)0.6f));
            }
        }
        drawContext.renderItem(this.itemStack, 8, 8);
        return startTime >= toastTimeMilliseconds ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

