/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class TrinketChangeCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("trinket_change");

    public void trigger(ServerPlayer player) {
        this.trigger(player, conditions -> {
            Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (curiosInventory.isPresent()) {
                ArrayList<ItemStack> equippedStacks = new ArrayList<ItemStack>();
                int spectrumStacks = 0;
                IItemHandlerModifiable equippedCurios = ((ICuriosItemHandler)curiosInventory.get()).getEquippedCurios();
                for (int i = 0; i < equippedCurios.getSlots(); ++i) {
                    ItemStack itemStack = equippedCurios.getStackInSlot(i);
                    equippedStacks.add(itemStack);
                    if (!(itemStack.getItem() instanceof PastelTrinketItem)) continue;
                    ++spectrumStacks;
                }
                return conditions.matches(equippedStacks, equippedStacks.size(), spectrumStacks);
            }
            return false;
        });
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<List<ItemPredicate>> itemPredicates, Optional<MinMaxBounds.Ints> totalCountRange, Optional<MinMaxBounds.Ints> spectrumCountRange) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("items").forGetter(Conditions::itemPredicates), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("total_count").forGetter(Conditions::totalCountRange), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("pastel_count").forGetter(Conditions::spectrumCountRange)).apply((Applicative)instance, Conditions::new));

        public boolean matches(List<ItemStack> trinketStacks, int totalCount, int spectrumCount) {
            if (this.totalCountRange.isPresent() && this.totalCountRange.get().matches(totalCount) || this.spectrumCountRange.isPresent() && this.spectrumCountRange.get().matches(spectrumCount)) {
                int i = this.itemPredicates.orElse(List.of()).size();
                if (i == 0) {
                    return true;
                }
                ObjectArrayList requiredTrinkets = new ObjectArrayList((Collection)this.itemPredicates.get());
                for (ItemStack trinketStack : trinketStacks) {
                    if (requiredTrinkets.isEmpty()) {
                        return true;
                    }
                    if (trinketStack.isEmpty()) continue;
                    requiredTrinkets.removeIf(item -> item.test(trinketStack));
                }
                return requiredTrinkets.isEmpty();
            }
            return false;
        }
    }
}

