/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class AzureDikeChargeCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("azure_dike_charge_change");

    public void trigger(ServerPlayer player, float charges, int rechargeRate, float change) {
        this.trigger(player, conditions -> conditions.matches(charges, rechargeRate, change));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints charges, MinMaxBounds.Ints rechargeRate, MinMaxBounds.Ints change) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("charges", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::charges), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("recharge_rate", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::rechargeRate), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("change", (Object)MinMaxBounds.Ints.ANY).forGetter(Conditions::change)).apply((Applicative)instance, Conditions::new));

        public boolean matches(float charges, int rechargeRate, float change) {
            return this.charges.matches(Math.round(charges)) && this.rechargeRate.matches(rechargeRate) && this.change.matches(Math.round(change));
        }
    }
}

