/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression;

import earth.terrarium.pastel.helpers.Support;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class GravityAdvancementsManager {
    private static long lastGravityTick = 0L;
    private static ServerPlayer lastServerPlayerEntity = null;
    private static double appliedGravityThisTick = 0.0;

    public static void processAppliedGravityForAdvancements(@NotNull ServerPlayer serverPlayerEntity, double additionalGravity) {
        ServerLevel serverWorld = (ServerLevel)serverPlayerEntity.level();
        if (serverWorld != null) {
            if (serverWorld.getGameTime() != lastGravityTick || lastServerPlayerEntity != serverPlayerEntity) {
                lastServerPlayerEntity = serverPlayerEntity;
                lastGravityTick = serverWorld.getGameTime();
                appliedGravityThisTick = 0.0;
            }
            if ((appliedGravityThisTick += additionalGravity) > 0.081) {
                Support.grantAdvancementCriterion(serverPlayerEntity, "lategame/carry_too_many_low_gravity_blocks", "gravity");
            } else if (appliedGravityThisTick < -0.025) {
                Support.grantAdvancementCriterion(serverPlayerEntity, "midgame/carry_too_many_heavy_gravity_blocks", "gravity");
            }
        }
    }
}

