/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import earth.terrarium.pastel.blocks.spirit_sallow.WindStrength;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WindParticle
extends TextureSheetParticle {
    private static final WindStrength wind = new WindStrength();

    protected WindParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(clientWorld, x, y - 0.125, z, velocityX, velocityY, velocityZ);
        this.hasPhysics = true;
        this.setSize(0.01f, 0.01f);
        this.quadSize *= this.random.nextFloat() * 0.4f + 0.7f;
        this.lifetime = 120;
    }

    public void tick() {
        super.tick();
        Vec3 windStrength = wind.getWindStrength((Level)this.level);
        this.xd += windStrength.x() * 0.004;
        this.yd += windStrength.y() * 0.001;
        this.zd += windStrength.z() * 0.004;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    protected int getLightColor(float tint) {
        return 0xF000F0;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            RandomSource random = clientWorld.getRandom();
            WindParticle particle = new WindParticle(clientWorld, x, y, z, velocityX * random.nextDouble(), (random.nextDouble() - 0.5) * 0.05, velocityZ * random.nextDouble());
            particle.pickSprite(this.spriteProvider);
            return particle;
        }
    }
}

