/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VoidFogParticle
extends TextureSheetParticle {
    protected VoidFogParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
        this.hasPhysics = true;
        this.setSize(0.01f, 0.01f);
        this.quadSize *= this.random.nextFloat() * 0.2f + 0.1f;
        this.lifetime = 100 + (int)(this.random.nextFloat() * 20.0f);
        this.xd = 0.0;
        this.yd = Math.random() * 0.05 + 0.05;
        this.zd = 0.0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    protected int getLightColor(float tint) {
        return 0;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            RandomSource random = clientWorld.getRandom();
            VoidFogParticle particle = new VoidFogParticle(clientWorld, x, y, z, 0.0, (random.nextDouble() - 0.5) * 0.05, 0.0);
            particle.pickSprite(this.spriteProvider);
            return particle;
        }
    }
}

