/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import earth.terrarium.pastel.helpers.render.ParticleHelper;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.VectorPattern;
import earth.terrarium.pastel.particle.effect.ColoredExplosionParticleEffect;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoonstoneStrikeParticle
extends NoRenderParticle {
    private static final int MAX_AGE = 40;

    MoonstoneStrikeParticle(ClientLevel clientWorld, double d, double e, double f) {
        super(clientWorld, d, e, f, 0.0, 0.0, 0.0);
    }

    public void tick() {
        boolean alt;
        if (this.age == 0) {
            this.level.addParticle((ParticleOptions)ColoredExplosionParticleEffect.WHITE, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        }
        Object particle = (alt = this.random.nextBoolean()) ? PastelParticleTypes.SHOOTING_STAR : ColoredSparkleRisingParticleEffect.WHITE;
        float velocity = alt ? 0.5f : 0.375f;
        double rotation = 0.15707963267948966 * (double)this.age;
        double nextRotation = 0.15707963267948966 * (double)(this.age + 1);
        ParticleHelper.playParticleWithRotation((Level)this.level, new Vec3(this.x, this.y, this.z), rotation, rotation, (ParticleOptions)particle, VectorPattern.EIGHT, velocity);
        ParticleHelper.playParticleWithRotation((Level)this.level, new Vec3(this.x, this.y, this.z), nextRotation, -nextRotation, (ParticleOptions)particle, VectorPattern.EIGHT, velocity);
        this.age += 2;
        if (this.age == 40) {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new MoonstoneStrikeParticle(clientWorld, d, e, f);
        }
    }
}

