/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BloodflyParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    private double lastVelX;
    private double lastVelZ;
    private int switchTicks = 10;
    private float r;
    private float g;
    private float b;

    protected BloodflyParticle(ClientLevel clientWorld, double d, double e, double f, double velocityX, double velocityY, double velocityZ, float scaleMultiplier, SpriteSet spriteProvider) {
        super(clientWorld, d, e, f, velocityX, velocityY, velocityZ);
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
        this.xd = this.random.nextFloat() * 0.05f - 0.025f;
        this.yd = 0.0;
        this.zd = this.random.nextFloat() * 0.05f - 0.025f;
        RandomSource random = clientWorld.getRandom();
        this.gravity = random.nextFloat() * 0.04f - 0.02f;
        this.hasPhysics = true;
        this.lifetime = 60 + random.nextInt(20);
        float dist = random.nextFloat();
        if (dist < 0.725f) {
            this.r = 255.0f;
            this.g = Mth.lerpInt((float)random.nextFloat(), (int)110, (int)175);
            this.b = Mth.lerpInt((float)random.nextFloat(), (int)60, (int)100);
        } else if (dist < 0.95f) {
            this.r = 170.0f;
            this.g = Mth.lerpInt((float)random.nextFloat(), (int)200, (int)255);
            this.b = Mth.lerpInt((float)random.nextFloat(), (int)235, (int)255);
        } else {
            this.r = 255.0f;
            this.g = 245.0f;
            this.b = Mth.lerpInt((float)random.nextFloat(), (int)235, (int)250);
        }
        this.r /= 255.0f;
        this.g /= 255.0f;
        this.b /= 255.0f;
        this.quadSize = 0.01f + random.nextFloat() * 0.325f;
        this.quadSize *= scaleMultiplier;
        this.setColor(this.r, this.g, this.b);
        this.setAlpha(0.0f);
    }

    public void tick() {
        boolean water;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        if (this.switchTicks < 10) {
            ++this.switchTicks;
        }
        boolean bl = water = !this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isEmpty();
        if (this.age % 11 == 0 && this.random.nextBoolean()) {
            this.switchTicks = 0;
            this.gravity = this.random.nextFloat() * 0.04f - 0.02f;
            this.lastVelX = this.xd;
            this.lastVelZ = this.zd;
            this.xd = this.random.nextFloat() * 0.05f - 0.025f;
            this.zd = this.random.nextFloat() * 0.05f - 0.025f;
        }
        double flutter = Math.sin((float)this.age / 8.0f) / 35.0;
        double curVelX = Mth.lerp((double)((float)this.switchTicks / 10.0f), (double)this.lastVelX, (double)this.xd);
        double curVelZ = Mth.lerp((double)((float)this.switchTicks / 10.0f), (double)this.lastVelZ, (double)this.zd);
        if (this.onGround || water) {
            curVelX *= (double)0.7f;
            curVelZ *= (double)0.7f;
            this.gravity = this.random.nextFloat() * 0.03f;
        }
        this.yd -= 0.04 * (double)this.gravity;
        this.move(curVelX, this.yd + flutter, curVelZ);
        if (this.speedUpWhenYMotionIsBlocked && this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.adjustAlpha(water);
    }

    private void adjustAlpha(boolean water) {
        if (this.age <= 15) {
            this.alpha = Mth.clamp((float)((float)this.age / 15.0f), (float)0.0f, (float)1.0f);
            return;
        }
        float ageFade = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, 20) / 20.0f), (float)0.0f, (float)1.0f);
        this.alpha = ageFade < 1.0f ? Math.min(this.alpha, ageFade) : (this.onGround ? Mth.clamp((float)(this.alpha - 0.02f), (float)0.0f, (float)1.0f) : (water ? Mth.clamp((float)(this.alpha - 0.02f), (float)0.5f, (float)1.0f) : Mth.clamp((float)(this.alpha + 0.05f), (float)0.0f, (float)1.0f)));
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    public int getLightColor(float tint) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new BloodflyParticle(clientWorld, d, e, f, 0.0, 0.0, 0.0, 1.0f, this.spriteProvider);
        }
    }
}

