/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.fusion_shrine.FusionShrineBlockEntity;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayFusionCraftingInProgressParticlePayload(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayFusionCraftingInProgressParticlePayload> ID = PastelC2SPackets.makeId("play_fusion_crafting_in_progress_particle");
    public static final StreamCodec<FriendlyByteBuf, PlayFusionCraftingInProgressParticlePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PlayFusionCraftingInProgressParticlePayload::pos, PlayFusionCraftingInProgressParticlePayload::new);

    public static void sendPlayFusionCraftingInProgressParticles(ServerLevel world, BlockPos pos) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new PlayFusionCraftingInProgressParticlePayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayFusionCraftingInProgressParticlePayload payload, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(payload.pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
            fusionShrineBlockEntity.spawnCraftingParticles();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

