/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.chests.FabricationChestBlockEntity;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FabricationChestStatusUpdatePayload(BlockPos pos, boolean isFull, boolean hasValidRecipes, List<ItemStack> stacks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FabricationChestStatusUpdatePayload> ID = PastelC2SPackets.makeId("fabrication_chest_status_update");
    public static final StreamCodec<RegistryFriendlyByteBuf, FabricationChestStatusUpdatePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, FabricationChestStatusUpdatePayload::pos, (StreamCodec)ByteBufCodecs.BOOL, FabricationChestStatusUpdatePayload::isFull, (StreamCodec)ByteBufCodecs.BOOL, FabricationChestStatusUpdatePayload::hasValidRecipes, (StreamCodec)ItemStack.LIST_STREAM_CODEC, FabricationChestStatusUpdatePayload::stacks, FabricationChestStatusUpdatePayload::new);

    public static void sendFabricationChestStatusUpdate(FabricationChestBlockEntity chest) {
        BlockPos pos = chest.getBlockPos();
        boolean isFull = chest.isFullServer();
        boolean hasValidRecipes = chest.hasValidRecipes();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(chest.getRecipeOutputs());
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)chest.getLevel()), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new FabricationChestStatusUpdatePayload(pos, isFull, hasValidRecipes, stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(FabricationChestStatusUpdatePayload payload, IPayloadContext context) {
        Level level = context.player().level();
        BlockPos pos = payload.pos;
        boolean isFull = payload.isFull;
        boolean hasValidRecipes = payload.hasValidRecipes;
        List<ItemStack> outputs = payload.stacks;
        Optional entity = level.getBlockEntity(pos, (BlockEntityType)PastelBlockEntities.FABRICATION_CHEST.get());
        if (entity.isPresent()) {
            ((FabricationChestBlockEntity)entity.get()).updateState(isFull, hasValidRecipes, outputs);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

