/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.c2s_payloads;

import earth.terrarium.pastel.api.block.InkColorSelectedPacketReceiver;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.networking.s2c_payloads.InkColorSelectedS2CPayload;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record InkColorSelectedC2SPayload(Optional<Holder<InkColor>> inkColor) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InkColorSelectedC2SPayload> ID = PastelC2SPackets.makeId("ink_color_select");
    public static final StreamCodec<RegistryFriendlyByteBuf, InkColorSelectedC2SPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)PastelRegistries.INK_COLOR.key())), InkColorSelectedC2SPayload::inkColor, InkColorSelectedC2SPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static IPayloadHandler<InkColorSelectedC2SPayload> getPayloadHandler() {
        return (payload, context) -> {
            ServerPlayer player = (ServerPlayer)context.player();
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (screenHandler instanceof InkColorSelectedPacketReceiver) {
                InkColorSelectedPacketReceiver inkColorSelectedPacketReceiver = (InkColorSelectedPacketReceiver)screenHandler;
                Optional<Holder<InkColor>> inkColor = payload.inkColor();
                inkColorSelectedPacketReceiver.onInkColorSelectedPacket(inkColor);
                for (ServerPlayer serverPlayer : player.level().getServer().getPlayerList().getPlayers()) {
                    InkColorSelectedPacketReceiver receiver;
                    AbstractContainerMenu patt0$temp = serverPlayer.containerMenu;
                    if (!(patt0$temp instanceof InkColorSelectedPacketReceiver) || (receiver = (InkColorSelectedPacketReceiver)patt0$temp).getBlockEntity() == null || receiver.getBlockEntity() != inkColorSelectedPacketReceiver.getBlockEntity()) continue;
                    InkColorSelectedS2CPayload.sendInkColorSelected(inkColor, serverPlayer);
                }
            }
        };
    }
}

