/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin.client;

import earth.terrarium.pastel.components.CustomPotionDataComponent;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={PotionItem.class, LingeringPotionItem.class, TippedArrowItem.class})
public abstract class PotionItemClientMixin {
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void makePotionUnidentifiable(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type, CallbackInfo ci) {
        CustomPotionDataComponent component = (CustomPotionDataComponent)stack.get(PastelDataComponentTypes.CUSTOM_POTION_DATA);
        if (component != null && component.unidentifiable()) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.potion.tooltip.unidentifiable"));
            ci.cancel();
        }
    }
}

