/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.attachments.data.SpectacleData;
import earth.terrarium.pastel.deeper_down.Environmental;
import earth.terrarium.pastel.deeper_down.EnvironmentalData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class}, priority=9999)
public class LightTextureMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @ModifyReturnValue(method={"calculateDarknessScale"}, at={@At(value="RETURN")})
    private float getDarkness(float original) {
        float lightMod = PastelCommon.CONFIG.DimensionBrightnessMod * 0.25f;
        if (Environmental.isActive().overrides) {
            EnvironmentalData data = Environmental.getEnvData();
            return Math.max(data.darkening() - lightMod, original);
        }
        return original;
    }

    @Inject(method={"updateLightTexture"}, at={@At(value="INVOKE", target="Lorg/joml/Vector3f;lerp(Lorg/joml/Vector3fc;F)Lorg/joml/Vector3f;", ordinal=0)})
    private void modifyNightVis(float partialTicks, CallbackInfo ci, @Local(ordinal=7) LocalFloatRef potency) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !SpectacleData.isActive((Player)player)) {
            return;
        }
        SpectacleData data = (SpectacleData)player.getData(SpectacleData.ATTACHMENT);
        if (potency.get() < data.getPotency()) {
            potency.set(data.getPotency());
        }
    }

    @ModifyExpressionValue(method={"updateLightTexture"}, at={@At(value="INVOKE", target="Ljava/lang/Double;floatValue()F", ordinal=1)})
    private float decreaseGamma(float gamma) {
        Entity entity;
        float mod;
        Environmental.State state = Environmental.isActive();
        float f = mod = state.force() ? PastelCommon.CONFIG.DimensionBrightnessMod : 0.25f;
        if (state.force() && (entity = this.minecraft.getCameraEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            gamma -= living.hasEffect(MobEffects.NIGHT_VISION) || SpectacleData.isActive((Player)this.minecraft.player) ? 0.275f : 0.0f;
        }
        if (state.overrides) {
            gamma = Mth.lerp((float)Environmental.getEnvData().darkening(), (float)gamma, (float)(gamma - 25.0f + mod));
        }
        return gamma;
    }
}

