/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.deeper_down.Environmental;
import earth.terrarium.pastel.registries.client.PastelShaders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class}, priority=9999)
public abstract class GameRendererMixin {
    @ModifyReturnValue(method={"getNightVisionScale"}, at={@At(value="RETURN")})
    private static float modifyNightVision(float original, LivingEntity entity, float tickDelta) {
        if (Environmental.isActive().force()) {
            original /= 6.0f;
        }
        return original *= 1.0f - Environmental.getEnvData().darkening();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getMainRenderTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;", shift=At.Shift.BEFORE)})
    private void applyPostProcessShaders(DeltaTracker tickCounter, boolean tick, CallbackInfo ci) {
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.resetTextureMatrix();
        PastelShaders.colorGradingPostProcess.ifPresent(pps -> pps.process(tickCounter.getGameTimeDeltaTicks()));
    }

    @Inject(method={"close"}, at={@At(value="TAIL")})
    private void closeShaders(CallbackInfo ci) {
        PastelShaders.clearDimensionShaders();
    }

    @Inject(method={"resize"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;resize(II)V")})
    private void resizeShaders(int width, int height, CallbackInfo ci) {
        PastelShaders.resizeShaders(width, height);
    }
}

