/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import earth.terrarium.pastel.entity.entity.BidentBaseEntity;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ThrownTrident.class})
public abstract class TridentEntityMixin
extends AbstractArrow {
    protected TridentEntityMixin(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    @WrapOperation(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean makeBidentDamageReasonable(Entity instance, DamageSource source, float amount, Operation<Boolean> original) {
        TridentEntityMixin tridentEntityMixin = this;
        if (tridentEntityMixin instanceof BidentBaseEntity) {
            BidentBaseEntity bidentEntity = (BidentBaseEntity)((Object)tridentEntityMixin);
            ItemStack stack = bidentEntity.getTrackedStack();
            float damage = (float)this.getDamage(stack);
            DamageSource damageSource = PastelDamageTypes.impaling(this.level(), (Entity)bidentEntity, this.getOwner());
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                damage += EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)this.getWeaponItem(), (Entity)instance, (DamageSource)damageSource, (float)damage);
            }
            return instance.hurt(damageSource, damage * 2.0f);
        }
        return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
    }

    @Unique
    private double getDamage(ItemStack stack) {
        ItemAttributeModifiers attributeModifiersComponent = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        return attributeModifiersComponent.compute(1.0, EquipmentSlot.MAINHAND);
    }
}

