/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.enchantments.DisarmingHelper;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.trinkets.GleamingPinItem;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin {
    @Unique
    private long lastGleamingPinTriggerTick = 0L;

    @Shadow
    public abstract ServerLevel serverLevel();

    @Inject(at={@At(value="RETURN")}, method={"hurt"})
    public void damageReturn(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel world = this.serverLevel();
        if (cir.getReturnValue() != null && ((Boolean)cir.getReturnValue()).booleanValue()) {
            Entity entity;
            ServerPlayer thisPlayer = (ServerPlayer)this;
            Optional<ItemStack> gleamingPinStack = PastelTrinketItem.getFirstEquipped((LivingEntity)thisPlayer, (Item)PastelItems.GLEAMING_PIN.get());
            if (gleamingPinStack.isPresent() && world.getGameTime() - this.lastGleamingPinTriggerTick > 160L) {
                GleamingPinItem.doGleamingPinEffect((Player)thisPlayer, world, gleamingPinStack.get());
                this.lastGleamingPinTriggerTick = world.getGameTime();
            }
            if ((entity = source.getEntity()) instanceof LivingEntity) {
                LivingEntity livingSource = (LivingEntity)entity;
                int disarmingLevel = Ench.getLevel((HolderLookup.Provider)world.registryAccess(), PastelEnchantments.DISARMING, livingSource.getMainHandItem());
                if (disarmingLevel > 0 && Math.random() < (double)((float)disarmingLevel * PastelCommon.CONFIG.DisarmingChancePerLevelPlayers)) {
                    DisarmingHelper.disarmEntity((LivingEntity)thisPlayer);
                }
            }
        }
    }
}

