/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.conditional.StuckStormStoneBlock;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBolt.class})
public abstract class LightningEntityMixin {
    @Shadow
    protected abstract BlockPos getStrikePosition();

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;clearCopperOnLightningStrike(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V")})
    private void spawnLightningStoneAtImpact(CallbackInfo ci) {
        Level world = ((LightningBolt)this).level();
        if (world.isThundering() && PastelCommon.CONFIG.StormStonesWorlds.contains(world.dimension().location().toString())) {
            this.spawnLightningStone(world, this.getStrikePosition());
        }
    }

    @Unique
    private void spawnLightningStone(@NotNull Level world, BlockPos affectedBlockPos) {
        BlockPos aboveGroundBlockPos;
        BlockState blockState = world.getBlockState(affectedBlockPos);
        if (blockState.is(PastelBlockTags.C_LIGHTNING_RODS)) {
            BlockPos blockPos2 = affectedBlockPos.relative(((Direction)blockState.getValue((Property)LightningRodBlock.FACING)).getOpposite());
            aboveGroundBlockPos = blockPos2.relative(Direction.from2DDataValue((int)world.getRandom().nextInt(6))).above();
        } else {
            if (world.random.nextFloat() > PastelCommon.CONFIG.StormStonesChance) {
                return;
            }
            aboveGroundBlockPos = affectedBlockPos.above();
        }
        if (world.isEmptyBlock(aboveGroundBlockPos)) {
            Direction randomDirection = Direction.from2DDataValue((int)world.random.nextInt(4));
            BlockState placementBlockState = (BlockState)((Block)PastelBlocks.STUCK_STORM_STONE.get()).defaultBlockState().setValue((Property)StuckStormStoneBlock.FACING, (Comparable)randomDirection);
            if (placementBlockState.canSurvive((LevelReader)world, aboveGroundBlockPos)) {
                world.setBlockAndUpdate(aboveGroundBlockPos, placementBlockState);
            }
        }
    }
}

