/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.blocks.deeper_down.flora.SawbladeHollyBushBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Fox.FoxEatBerriesGoal.class})
public abstract class EatBerriesGoalMixin
extends MoveToBlockGoal {
    @Unique
    private final Fox foxEntity;

    public EatBerriesGoalMixin(PathfinderMob mob, double speed, int range) {
        super(mob, speed, range);
        this.foxEntity = (Fox)this.mob;
    }

    @Inject(method={"isValidTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void isTargetPos(LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is((Block)PastelBlocks.SAWBLADE_HOLLY_BUSH.get()) && (Integer)blockState.getValue((Property)SawbladeHollyBushBlock.AGE) == 7) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onReachedTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void eatBerries(CallbackInfo ci) {
        BlockState blockState;
        if (this.foxEntity.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && (blockState = this.foxEntity.level().getBlockState(this.blockPos)).is((Block)PastelBlocks.SAWBLADE_HOLLY_BUSH.get())) {
            this.pickSawbladeHollyBerries(blockState);
            ci.cancel();
        }
    }

    @Unique
    private void pickSawbladeHollyBerries(BlockState state) {
        Level world = this.foxEntity.level();
        int age = (Integer)state.getValue((Property)SawbladeHollyBushBlock.AGE);
        int berriesPlucked = 1 + world.random.nextInt(2) + (age == 7 ? 1 : 0);
        ItemStack itemStack = this.foxEntity.getItemBySlot(EquipmentSlot.MAINHAND);
        if (itemStack.isEmpty()) {
            this.foxEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)PastelItems.SAWBLADE_HOLLY_BERRY.get()));
            --berriesPlucked;
        }
        if (berriesPlucked > 0) {
            Block.popResource((Level)world, (BlockPos)this.blockPos, (ItemStack)new ItemStack((ItemLike)PastelItems.SAWBLADE_HOLLY_BERRY.get(), berriesPlucked));
        }
        this.foxEntity.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
        world.setBlock(this.blockPos, (BlockState)state.setValue((Property)SawbladeHollyBushBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
    }
}

