/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.loot.PastelLootFunctionTypes;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class FillPotionFillableLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<FillPotionFillableLootFunction> CODEC = RecordCodecBuilder.mapCodec(i -> FillPotionFillableLootFunction.commonFields((RecordCodecBuilder.Instance)i).and((App)InkPoweredPotionTemplate.CODEC.forGetter(c -> c.template)).apply((Applicative)i, FillPotionFillableLootFunction::new));
    private final InkPoweredPotionTemplate template;

    FillPotionFillableLootFunction(List<LootItemCondition> conditions, InkPoweredPotionTemplate template) {
        super(conditions);
        this.template = template;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return PastelLootFunctionTypes.FILL_POTION_FILLABLE;
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (this.template == null) {
            return stack;
        }
        Item item = stack.getItem();
        if (!(item instanceof InkPoweredPotionFillable)) {
            return stack;
        }
        InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)item;
        if (inkPoweredPotionFillable.isFull(stack)) {
            return stack;
        }
        InkPoweredStatusEffectInstance effect = this.template.get(context);
        inkPoweredPotionFillable.addOrUpgradeEffects(stack, List.of(effect));
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(InkPoweredPotionTemplate template) {
        return FillPotionFillableLootFunction.simpleBuilder(conditions -> new FillPotionFillableLootFunction((List<LootItemCondition>)conditions, template));
    }

    public record InkPoweredPotionTemplate(boolean ambient, boolean showParticles, NumberProvider duration, List<Holder<MobEffect>> statusEffects, int color, NumberProvider amplifier, List<InkColor> inkColors, NumberProvider inkCost, boolean unidentifiable, boolean incurable) {
        public static final MapCodec<InkPoweredPotionTemplate> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(InkPoweredPotionTemplate::ambient), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)false).forGetter(InkPoweredPotionTemplate::showParticles), (App)NumberProviders.CODEC.fieldOf("duration").forGetter(InkPoweredPotionTemplate::duration), (App)CodecHelper.singleOrList(BuiltInRegistries.MOB_EFFECT.holderByNameCodec()).fieldOf("status_effect").forGetter(InkPoweredPotionTemplate::statusEffects), (App)Codec.INT.optionalFieldOf("color", (Object)-1).forGetter(InkPoweredPotionTemplate::color), (App)NumberProviders.CODEC.fieldOf("amplifier").forGetter(InkPoweredPotionTemplate::amplifier), (App)CodecHelper.singleOrList(InkColor.CODEC).fieldOf("ink_color").forGetter(InkPoweredPotionTemplate::inkColors), (App)NumberProviders.CODEC.fieldOf("ink_cost").forGetter(InkPoweredPotionTemplate::inkCost), (App)Codec.BOOL.optionalFieldOf("unidentifiable", (Object)false).forGetter(InkPoweredPotionTemplate::unidentifiable), (App)Codec.BOOL.optionalFieldOf("incurable", (Object)false).forGetter(InkPoweredPotionTemplate::incurable)).apply((Applicative)i, InkPoweredPotionTemplate::new));

        public InkPoweredStatusEffectInstance get(LootContext context) {
            Holder<MobEffect> statusEffect = this.statusEffects.get(context.getRandom().nextInt(this.statusEffects.size()));
            MobEffectInstance statusEffectInstance = new MobEffectInstance(statusEffect, this.duration.getInt(context), this.amplifier.getInt(context), this.ambient, this.showParticles, true);
            InkColor inkColor = this.inkColors.get(context.getRandom().nextInt(this.inkColors.size()));
            int cost = this.inkCost.getInt(context);
            return new InkPoweredStatusEffectInstance(statusEffectInstance, new InkCost(inkColor, cost), this.color, this.unidentifiable, this.incurable);
        }
    }
}

