/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class WeepingCircletItem
extends PastelTrinketItem {
    private static final int TRIGGER_EVERY_X_TICKS = 40;
    private static final int EFFECT_DURATION = 50;
    private static final int HEAL_AXOLOTLS_EVERY_X_TICKS = 160;
    private static final int MAX_AXOLOTL_DISTANCE = 12;
    private static final int AXOLOTL_HEALING = 2;

    public WeepingCircletItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/weeping_circlet"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.weeping_circlet.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.weeping_circlet.tooltip2").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.weeping_circlet.tooltip3").withStyle(ChatFormatting.GRAY));
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        this.doEffects(slotContext.entity(), true);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        this.doEffects(slotContext.entity(), false);
    }

    private void doEffects(LivingEntity entity, boolean always) {
        Level world = entity.level();
        if (!world.isClientSide) {
            long time = entity.level().getGameTime();
            if (entity.getEyeInFluidType().canSwim((Entity)entity)) {
                if (always || time % 40L == 0L) {
                    entity.setAirSupply(entity.getMaxAirSupply());
                    entity.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 50, 1, true, true));
                    entity.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 50, 0, true, true));
                }
                if ((always || time % 160L == 0L) && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                    this.healLovingAxolotls(serverPlayerEntity);
                }
            }
        }
    }

    private void healLovingAxolotls(@NotNull ServerPlayer entity) {
        Level world = entity.level();
        List nearbyAxolotls = entity.level().getEntities((EntityTypeTest)EntityType.AXOLOTL, AABB.ofSize((Vec3)entity.position(), (double)12.0, (double)12.0, (double)12.0), LivingEntity::isAlive);
        for (Axolotl axolotlEntity : nearbyAxolotls) {
            if (!(axolotlEntity.getHealth() < axolotlEntity.getMaxHealth()) || axolotlEntity.getLoveCause() == null || !axolotlEntity.getLoveCause().equals((Object)entity)) continue;
            axolotlEntity.heal(2.0f);
            entity.playSound(PastelSounds.BLOCK_CITRINE_BLOCK_CHIME, 1.0f, 0.9f + world.random.nextFloat() * 0.2f);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)axolotlEntity.level(), axolotlEntity.position(), (ParticleOptions)ParticleTypes.WAX_OFF, 10, new Vec3(0.5, 0.5, 0.5), new Vec3(0.0, 0.0, 0.0));
        }
    }
}

