/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayTakeOffBeltSoundInstancePayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.VectorPattern;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;

public class TakeOffBeltItem
extends PastelTrinketItem {
    public static final int CHARGE_TIME_TICKS = 20;
    public static final int MAX_CHARGES = 8;
    private static final HashMap<LivingEntity, Long> sneakingTimes = new HashMap();

    public TakeOffBeltItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/take_off_belt"));
    }

    public static int getJumpBoostAmplifier(int sneakTime, int powerEnchantmentLevel) {
        return (int)Math.floor((double)sneakTime * (2.0 + (double)powerEnchantmentLevel * 0.5));
    }

    public static int getCurrentCharge(Player playerEntity) {
        if (sneakingTimes.containsKey(playerEntity)) {
            return (int)(playerEntity.level().getGameTime() - sneakingTimes.get(playerEntity)) / 20;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.take_off_belt.tooltip").withStyle(ChatFormatting.GRAY));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level world = entity.level();
        super.curioTick(slotContext, stack);
        if (!world.isClientSide) {
            long lastSneakingTime;
            if (entity.isShiftKeyDown() && entity.onGround()) {
                if (sneakingTimes.containsKey(entity)) {
                    long sneakTicks = world.getGameTime() - sneakingTimes.get(entity);
                    if (sneakTicks % 20L == 0L) {
                        if (sneakTicks > 160L) {
                            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), PastelSounds.USE_FAIL, SoundSource.NEUTRAL, 4.0f, 1.05f);
                            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)world, entity.position(), ColoredCraftingParticleEffect.BLACK, 20, new Vec3(0.0, 0.0, 0.0), new Vec3(0.1, 0.05, 0.1));
                            entity.removeEffect(MobEffects.JUMP);
                        } else {
                            int sneakTimeMod = (int)sneakTicks / 20;
                            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), PastelSounds.BLOCK_TOPAZ_BLOCK_HIT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            for (Vec3 vec : VectorPattern.SIXTEEN.getVectors()) {
                                PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity((ServerLevel)world, entity.position(), (ParticleOptions)PastelParticleTypes.LIQUID_CRYSTAL_SPARKLE, 1, vec.scale(0.5));
                            }
                            int powerEnchantmentLevel = Ench.getLevel((HolderLookup.Provider)world.registryAccess(), (ResourceKey<Enchantment>)Enchantments.POWER, stack);
                            int featherFallingEnchantmentLevel = Ench.getLevel((HolderLookup.Provider)world.registryAccess(), (ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING, stack);
                            entity.addEffect(new MobEffectInstance(MobEffects.JUMP, 20, TakeOffBeltItem.getJumpBoostAmplifier(sneakTimeMod, powerEnchantmentLevel), true, true));
                            if (featherFallingEnchantmentLevel > 0) {
                                entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 20 + featherFallingEnchantmentLevel * 20, 0, true, true));
                            }
                        }
                    }
                } else {
                    sneakingTimes.put(entity, world.getGameTime());
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                        PlayTakeOffBeltSoundInstancePayload.sendPlayTakeOffBeltSoundInstance(serverPlayerEntity);
                    }
                }
            } else if (world.getGameTime() % 20L == 0L && sneakingTimes.containsKey(entity) && (lastSneakingTime = sneakingTimes.get(entity).longValue()) < world.getGameTime() + 20L) {
                sneakingTimes.remove(entity);
            }
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 8;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.POWER) || enchantment.is(Enchantments.FEATHER_FALLING);
    }
}

