/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.attachments.data.SpectacleData;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class PriscillentSpectaclesItem
extends PastelTrinketItem
implements InkPowered,
ExtendedItemBar {
    public PriscillentSpectaclesItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/glow_vision_goggles"));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ((SpectacleData)player.getData(SpectacleData.ATTACHMENT)).tickServer();
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ((SpectacleData)player.getData(SpectacleData.ATTACHMENT)).sync();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (InkPowered.canUseClient()) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.glow_vision_goggles.tooltip_with_ink", (Object[])new Object[]{SpectacleData.INK_COST.color().getColoredInkName()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.glow_vision_goggles.tooltip"));
        }
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(SpectacleData.INK_COST.color());
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        if (player == null || PastelTrinketItem.getFirstEquipped((LivingEntity)player, (Item)PastelItems.PRISCILLENT_SPECTACLES.get()).map(s -> s != stack).orElse(true).booleanValue()) {
            return ExtendedItemBar.PASS;
        }
        SpectacleData data = (SpectacleData)player.getData(SpectacleData.ATTACHMENT);
        int progress = (int)Math.floor(Mth.clampedLerp((float)0.0f, (float)13.0f, (float)data.getRemainingDuration()));
        return new ExtendedItemBar.BarSignature(2, 13, 13, progress, 1, -10627, 2, -16055003);
    }
}

