/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.items.tools.PastelPickaxeItem;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import earth.terrarium.pastel.registries.PastelEnchantments;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class OblivionPickaxeItem
extends PastelPickaxeItem {
    public OblivionPickaxeItem(Tier material, Item.Properties settings) {
        super(material, settings);
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        super.mineBlock(stack, world, state, pos, miner);
        if (!world.isClientSide && !EnchantmentHelper.hasTag((ItemStack)stack, PastelEnchantmentTags.NO_BLOCK_DROPS)) {
            stack.hurtAndBreak(5000, miner, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    @Override
    public Map<ResourceKey<Enchantment>, Integer> getDefaultEnchantments() {
        return Map.of(PastelEnchantments.VOIDING, 1);
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }
}

