/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.map;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureLocatorAsync {
    private final ServerLevel world;
    private final Optional<HolderSet<Structure>> structures;
    private final AtomicBoolean pinging;
    private final long delayMillis;
    private long nextTime = 0L;

    public StructureLocatorAsync(ServerLevel world, ResourceLocation targetId, long delayMillis) {
        this.world = world;
        this.structures = world.registryAccess().registryOrThrow(Registries.STRUCTURE).getHolder(targetId).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0}));
        this.pinging = new AtomicBoolean(false);
        this.delayMillis = delayMillis;
    }

    public void ping(BlockPos pos, BiConsumer<LevelAccessor, BlockPos> acceptor) {
        if (this.structures.isEmpty() || this.pinging.get()) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time < this.nextTime) {
            return;
        }
        this.nextTime = time + this.delayMillis;
        CompletableFuture.runAsync(() -> {
            this.pinging.set(true);
            ChunkGenerator generator = this.world.getChunkSource().getGenerator();
            Pair pair = generator.findNearestMapStructure(this.world, this.structures.get(), pos, 100, false);
            if (pair != null) {
                acceptor.accept((LevelAccessor)this.world, (BlockPos)pair.getFirst());
            }
            this.pinging.set(false);
        }, Util.backgroundExecutor());
    }
}

