/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.map;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.pastel.items.map.ArtisansAtlasState;
import earth.terrarium.pastel.registries.PastelStructureTags;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ArtisansAtlasItem
extends MapItem {
    public static final int COOLDOWN_DURATION_TICKS = 20;

    public ArtisansAtlasItem(Item.Properties settings) {
        super(settings);
    }

    private static void createAndSetState(ItemStack stack, ServerLevel world, int centerX, int centerZ, @Nullable StructureStart target, @Nullable ResourceLocation targetId) {
        ArtisansAtlasState state = new ArtisansAtlasState(centerX, centerZ, 1, true, true, false, (ResourceKey<Level>)world.dimension());
        MapId id = world.getFreeMapId();
        state.setTargetId(targetId);
        if (targetId != null) {
            state.startLocator(world);
            if (target != null) {
                state.addTarget((LevelAccessor)world, target.getBoundingBox().getCenter());
            }
        } else {
            state.cancelLocator();
        }
        world.setMapData(id, (MapItemSavedData)state);
        stack.set(DataComponents.MAP_ID, (Object)id);
    }

    public void update(Level world, Entity entity, MapItemSavedData state) {
        Player playerEntity;
        block13: {
            block12: {
                if (world.dimension() != state.dimension || !(entity instanceof Player)) break block12;
                playerEntity = (Player)entity;
                if (state instanceof ArtisansAtlasState) break block13;
            }
            return;
        }
        ArtisansAtlasState atlasState = (ArtisansAtlasState)state;
        int sampleSize = 1 << state.scale;
        MapItemSavedData.HoldingPlayer playerUpdateTracker = state.getHoldingPlayer(playerEntity);
        ++playerUpdateTracker.step;
        Vec3i delta = atlasState.getDisplayDelta();
        if (delta == null) {
            delta = entity.blockPosition().subtract((Vec3i)atlasState.getDisplayedCenter());
            int deltaX = delta.getX() / sampleSize;
            int deltaZ = delta.getZ() / sampleSize;
            for (int x = 0; x <= 127; ++x) {
                this.updateVerticalStrip(world, atlasState, deltaX, deltaZ, x, 0, 127);
            }
            atlasState.clearDisplayDelta();
            return;
        }
        int deltaX = delta.getX() / sampleSize;
        int deltaZ = delta.getZ() / sampleSize;
        if (deltaX < 0) {
            int x;
            for (x = 127; x >= -deltaX; --x) {
                this.updateOrCopyVerticalStrip(world, atlasState, deltaX, deltaZ, x, playerUpdateTracker.step);
            }
            for (x = 0; x <= Math.min(127, -deltaX - 1); ++x) {
                this.updateVerticalStrip(world, atlasState, deltaX, deltaZ, x, 0, 127);
            }
        } else {
            int x;
            for (x = 0; x <= 127 - deltaX; ++x) {
                this.updateOrCopyVerticalStrip(world, atlasState, deltaX, deltaZ, x, playerUpdateTracker.step);
            }
            for (x = Math.max(0, 127 - deltaX + 1); x <= 127; ++x) {
                this.updateVerticalStrip(world, atlasState, deltaX, deltaZ, x, 0, 127);
            }
        }
        if (deltaX != 0 || deltaZ != 0) {
            atlasState.clearDisplayDelta();
        }
    }

    private void updateOrCopyVerticalStrip(Level world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int tick) {
        if (deltaX > 127 || deltaX < -127 || deltaZ > 127 || deltaZ < -127 || (x & 0xF) == (tick & 0xF)) {
            this.updateVerticalStrip(world, state, deltaX, deltaZ, x, 0, 127);
        } else if (deltaZ < 0) {
            this.copyVerticalStrip(state, deltaX, deltaZ, x, 127, -deltaZ);
            this.updateVerticalStrip(world, state, deltaX, deltaZ, x, 0, -deltaZ - 1);
        } else if (deltaZ > 0) {
            this.copyVerticalStrip(state, deltaX, deltaZ, x, 0, 127 - deltaZ);
            this.updateVerticalStrip(world, state, deltaX, deltaZ, x, 127 - deltaZ + 1, 127);
        } else if (deltaX != 0) {
            this.copyVerticalStrip(state, deltaX, deltaZ, x, 0, 127);
        }
    }

    private void copyVerticalStrip(ArtisansAtlasState state, int deltaX, int deltaZ, int x, int startZ, int endZ) {
        if (startZ > endZ) {
            for (int z = startZ; z >= endZ; --z) {
                state.setColor(x, z, state.colors[x + deltaX + (z + deltaZ) * 128]);
            }
        } else {
            for (int z = startZ; z <= endZ; ++z) {
                state.setColor(x, z, state.colors[x + deltaX + (z + deltaZ) * 128]);
            }
        }
    }

    private void updateVerticalStrip(Level world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int startZ, int endZ) {
        double previousHeight = this.getHeight(world, state, deltaX, deltaZ, x, startZ - 1);
        for (int z = startZ; z <= endZ; ++z) {
            previousHeight = this.updateColor(world, state, deltaX, deltaZ, x, z, previousHeight);
        }
    }

    private double updateColor(Level world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int z, double previousHeight) {
        double f;
        double depth;
        double height;
        int sampleSize = 1 << state.scale;
        int sampleArea = sampleSize * sampleSize;
        int sampleMask = sampleSize - 1;
        boolean hasCeiling = world.dimensionType().hasCeiling();
        int blockX = ((state.getDisplayedCenter().getX() >> state.scale) + deltaX + x - 64) * sampleSize;
        int blockZ = ((state.getDisplayedCenter().getZ() >> state.scale) + deltaZ + z - 64) * sampleSize;
        LevelChunk chunk = world.getChunk(SectionPos.blockToSectionCoord((int)blockX), SectionPos.blockToSectionCoord((int)blockZ));
        if (chunk.isEmpty()) {
            return previousHeight;
        }
        int[] multiset = new int[64];
        int fluidDepth = 0;
        if (hasCeiling) {
            int hash = blockX + blockZ * 231871;
            if (((hash = hash * hash * 31287121 + hash * 11) >> 20 & 1) == 0) {
                int n = Blocks.DIRT.defaultBlockState().getMapColor((BlockGetter)world, (BlockPos)BlockPos.ZERO).id;
                multiset[n] = multiset[n] + 10;
            } else {
                int n = Blocks.STONE.defaultBlockState().getMapColor((BlockGetter)world, (BlockPos)BlockPos.ZERO).id;
                multiset[n] = multiset[n] + 100;
            }
            height = 100.0;
        } else {
            height = 0.0;
            int bottomY = world.getMinBuildHeight();
            BlockPos.MutableBlockPos samplePos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (int sample = 0; sample < sampleArea; ++sample) {
                MapColor mapColor;
                int posX = blockX + (sample >> state.scale);
                int posZ = blockZ + (sample & sampleMask);
                samplePos.setX(posX);
                samplePos.setZ(posZ);
                int sampleY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, posX, posZ) + 1;
                if (sampleY <= bottomY + 1) {
                    blockState = Blocks.BEDROCK.defaultBlockState();
                    mapColor = blockState.getMapColor((BlockGetter)world, (BlockPos)samplePos);
                } else {
                    do {
                        samplePos.setY(--sampleY);
                    } while ((mapColor = (blockState = chunk.getBlockState((BlockPos)samplePos)).getMapColor((BlockGetter)world, (BlockPos)samplePos)) == MapColor.NONE && sampleY > bottomY);
                    if (sampleY > bottomY && !blockState.getFluidState().isEmpty()) {
                        BlockState fluidBlockState;
                        int fluidY = sampleY - 1;
                        BlockPos.MutableBlockPos fluidPos = samplePos.mutable();
                        do {
                            fluidPos.setY(fluidY--);
                            fluidBlockState = chunk.getBlockState((BlockPos)fluidPos);
                        } while (fluidY > bottomY && !fluidBlockState.getFluidState().isEmpty());
                        fluidDepth += sampleY - 1 - fluidY;
                        FluidState fluidState = blockState.getFluidState();
                        blockState = !fluidState.isEmpty() && !blockState.isFaceSturdy((BlockGetter)world, (BlockPos)samplePos, Direction.UP) ? fluidState.createLegacyBlock() : blockState;
                        mapColor = blockState.getMapColor((BlockGetter)world, (BlockPos)samplePos);
                    }
                }
                state.checkBanners((BlockGetter)world, posX, posZ);
                height += (double)sampleY;
                int n = mapColor.id;
                multiset[n] = multiset[n] + 1;
            }
            height /= (double)sampleArea;
            fluidDepth /= sampleArea;
        }
        int maxCount = 0;
        MapColor color = MapColor.NONE;
        for (int i = 0; i < multiset.length; ++i) {
            if (multiset[i] <= maxCount) continue;
            maxCount = multiset[i];
            color = MapColor.byId((int)i);
        }
        int odd = (blockX ^ blockZ) / sampleSize & 1;
        MapColor.Brightness brightness = color == MapColor.WATER ? ((depth = (double)fluidDepth * 0.1 + (double)odd * 0.2) < 0.5 ? MapColor.Brightness.HIGH : (depth > 0.9 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL)) : ((f = (height - previousHeight) * 4.0 / (double)(sampleSize + 4) + ((double)odd - 0.5) * 0.4) > 0.6 ? MapColor.Brightness.HIGH : (f < -0.6 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL));
        state.setColor(x, z, color.getPackedId(brightness));
        return height;
    }

    private double getHeight(Level world, ArtisansAtlasState state, int deltaX, int deltaZ, int x, int z) {
        double height;
        int sampleSize = 1 << state.scale;
        int sampleArea = sampleSize * sampleSize;
        int sampleMask = sampleSize - 1;
        int blockX = ((state.getDisplayedCenter().getX() >> state.scale) + deltaX + x - 64) * sampleSize;
        int blockZ = ((state.getDisplayedCenter().getZ() >> state.scale) + deltaZ + z - 64) * sampleSize;
        LevelChunk chunk = world.getChunk(SectionPos.blockToSectionCoord((int)blockX), SectionPos.blockToSectionCoord((int)blockZ));
        if (chunk.isEmpty()) {
            return 0.0;
        }
        if (world.dimensionType().hasCeiling()) {
            height = 100.0;
        } else {
            height = 0.0;
            int bottomY = world.getMinBuildHeight();
            for (int sample = 0; sample < sampleArea; ++sample) {
                int posX = blockX + (sample >> state.scale);
                int posZ = blockZ + (sample & sampleMask);
                BlockPos.MutableBlockPos samplePos = new BlockPos.MutableBlockPos(posX, 0, posZ);
                int sampleY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, posX, posZ) + 1;
                if (sampleY > bottomY + 1) {
                    BlockState blockState;
                    do {
                        samplePos.setY(--sampleY);
                    } while ((blockState = chunk.getBlockState((BlockPos)samplePos)).getMapColor((BlockGetter)world, (BlockPos)samplePos) == MapColor.NONE && sampleY > bottomY);
                }
                height += (double)sampleY;
            }
            height /= (double)sampleArea;
        }
        return height;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        MapItemSavedData state;
        if (!world.isClientSide && (state = ArtisansAtlasItem.getSavedData((ItemStack)stack, (Level)world)) instanceof ArtisansAtlasState) {
            ArtisansAtlasState atlasState = (ArtisansAtlasState)state;
            atlasState.updateDimension((ResourceKey<Level>)world.dimension());
        }
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level;
        if (!context.getLevel().isClientSide() && (level = context.getLevel()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            level = context.getPlayer();
            if (level instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)level;
                ItemStack stack = serverPlayerEntity.getItemInHand(context.getHand());
                if (serverPlayerEntity.isShiftKeyDown()) {
                    Vec3 hitPos = context.getClickLocation();
                    BlockPos blockPos = BlockPos.containing((double)hitPos.x(), (double)hitPos.y(), (double)hitPos.z());
                    Pair<ResourceLocation, StructureStart> pair = ArtisansAtlasState.locateAnyStructureAtBlock(serverWorld, blockPos);
                    if (pair != null) {
                        ResourceLocation structureId = (ResourceLocation)pair.getFirst();
                        if (PastelStructureTags.isIn((Level)serverWorld, structureId, PastelStructureTags.UNLOCATABLE)) {
                            serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"item.pastel.artisans_atlas.unlocatable"), true);
                        } else {
                            serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"item.pastel.artisans_atlas.set_structure").append((Component)Component.translatable((String)structureId.toLanguageKey("structure"))), true);
                            ArtisansAtlasItem.createAndSetState(stack, serverWorld, (int)serverPlayerEntity.getX(), (int)serverPlayerEntity.getZ(), (StructureStart)pair.getSecond(), (ResourceLocation)pair.getFirst());
                        }
                    }
                    serverPlayerEntity.getCooldowns().addCooldown(stack.getItem(), 20);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (!world.isClientSide() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)user;
                if (user.isShiftKeyDown()) {
                    ArtisansAtlasItem.createAndSetState(stack, serverWorld, (int)serverPlayerEntity.getX(), (int)serverPlayerEntity.getZ(), null, null);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        MapItemSavedData mapItemSavedData = ArtisansAtlasItem.getSavedData((ItemStack)stack, (Level)world);
        if (mapItemSavedData instanceof ArtisansAtlasState) {
            ArtisansAtlasState atlasState = (ArtisansAtlasState)mapItemSavedData;
            ResourceLocation structureId = atlasState.getTargetId();
            if (structureId == null) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.artisans_atlas.empty"));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.artisans_atlas.locates_structure").append((Component)Component.translatable((String)structureId.toLanguageKey("structure"))));
            }
        }
    }
}

