/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items.ampoules;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class GlassAmpouleItem
extends Item {
    public GlassAmpouleItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (this.trigger(user.level(), stack, (LivingEntity)user, null, user.getEyePosition())) {
            if (!user.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return world.isClientSide() ? InteractionResultHolder.fail((Object)stack) : InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        Level world = user.level();
        if (this.trigger(user.level(), stack, (LivingEntity)user, entity, user.getEyePosition())) {
            if (!user.level().isClientSide && !user.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return world.isClientSide() ? InteractionResult.FAIL : InteractionResult.PASS;
    }

    public abstract boolean trigger(Level var1, ItemStack var2, LivingEntity var3, @Nullable LivingEntity var4, Vec3 var5);
}

