/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items.ampoules;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.PrioritizedEntityInteraction;
import earth.terrarium.pastel.entity.entity.LightShardBaseEntity;
import earth.terrarium.pastel.entity.entity.LightSpearEntity;
import earth.terrarium.pastel.items.magic_items.ampoules.GlassAmpouleItem;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BloodstoneGlassAmpouleItem
extends GlassAmpouleItem
implements PrioritizedEntityInteraction {
    protected static final float EXTRA_REACH = 12.0f;
    protected static final ResourceLocation REACH_ENTITY_INTERACTION_MODIFIER_ID = PastelCommon.locate("bloodstone_glass_ampoule_reach");

    public BloodstoneGlassAmpouleItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemAttributeModifiers createAttributeModifiers() {
        return ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(REACH_ENTITY_INTERACTION_MODIFIER_ID, 12.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    @Override
    public boolean trigger(Level world, ItemStack stack, LivingEntity attacker, @Nullable LivingEntity target, Vec3 position) {
        world.playLocalSound(BlockPos.containing((Position)position), PastelSounds.LIGHT_CRYSTAL_RING, SoundSource.PLAYERS, 0.35f, 0.9f + world.getRandom().nextFloat() * 0.334f, true);
        LightSpearEntity.summonBarrage(world, attacker, target, LightShardBaseEntity.MONSTER_TARGET, position, LightShardBaseEntity.DEFAULT_COUNT_PROVIDER);
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.bloodstone_glass_ampoule.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

