/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.item.DamageAwareItem;
import earth.terrarium.pastel.api.item.TickAwareItem;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.PipeBombChargingSoundInstance;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PipeBombItem
extends Item
implements DamageAwareItem,
TickAwareItem {
    public PipeBombItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (PipeBombItem.isPrimed(user.getItemInHand(hand))) {
            return super.use(world, user, hand);
        }
        if (world.isClientSide) {
            this.startSoundInstance(user);
        }
        return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSoundInstance(Player user) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new PipeBombChargingSoundInstance(user));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 55;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        PipeBombItem.prime(stack, world, user.position(), (Entity)user);
        return stack;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (PipeBombItem.isPrimeTimeElapsed(world, stack)) {
                this.explode(stack, serverWorld, entity.position(), entity);
            }
        }
    }

    @Override
    public void onItemEntityTicked(ItemEntity itemEntity) {
        ServerLevel world;
        ItemStack stack = itemEntity.getItem();
        Level level = itemEntity.level();
        if (level instanceof ServerLevel && PipeBombItem.isPrimeTimeElapsed((Level)(world = (ServerLevel)level), stack)) {
            this.explode(stack, world, itemEntity.getEyePosition(), null);
        }
    }

    @Override
    public void onItemEntityDamaged(DamageSource source, float amount, ItemEntity itemEntity) {
        Level level = itemEntity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypeTags.IS_EXPLOSION)) {
                this.explode(itemEntity.getItem(), world, itemEntity.position(), null);
            }
        }
    }

    private void explode(ItemStack stack, ServerLevel world, Vec3 pos, @Nullable Entity target) {
        stack.shrink(1);
        Entity owner = this.tryGetOwner(stack, world);
        if (target != null) {
            LivingEntity living;
            target.hurt(PastelDamageTypes.incandescence((Level)world, owner instanceof LivingEntity ? (living = (LivingEntity)owner) : null), 200.0f);
        }
        world.explode(null, PastelDamageTypes.incandescence((Level)world), new ExplosionDamageCalculator(), pos.x(), pos.y(), pos.z(), 7.5f, true, Level.ExplosionInteraction.NONE);
    }

    public Entity tryGetOwner(ItemStack stack, ServerLevel world) {
        ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        if (profile == null || profile.id().isEmpty()) {
            return null;
        }
        return world.getEntity((UUID)profile.id().get());
    }

    public static void prime(ItemStack stack, Level world, Vec3 pos, @Nullable Entity user) {
        world.playSound(null, pos.x(), pos.y(), pos.z(), PastelSounds.INCANDESCENT_ARM, SoundSource.PLAYERS, 2.0f, 0.9f);
        stack.set(PastelDataComponentTypes.TIMESTAMP, (Object)world.getGameTime());
        if (user instanceof Player) {
            Player player = (Player)user;
            stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
        }
    }

    public static boolean isPrimed(ItemStack stack) {
        return stack.get(PastelDataComponentTypes.TIMESTAMP) != null;
    }

    public static boolean isPrimeTimeElapsed(Level world, ItemStack stack) {
        Optional<Long> timestamp = PipeBombItem.getPrimeTime(stack);
        if (timestamp.isEmpty()) {
            return false;
        }
        return world.getGameTime() - timestamp.get() >= 100L;
    }

    private static Optional<Long> getPrimeTime(ItemStack stack) {
        if (stack.has(PastelDataComponentTypes.TIMESTAMP)) {
            return Optional.of((Long)stack.get(PastelDataComponentTypes.TIMESTAMP));
        }
        return Optional.empty();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.pipe_bomb.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.pipe_bomb.tooltip2").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.pipe_bomb.tooltip3").withStyle(ChatFormatting.GRAY));
    }
}

