/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.blocks.CrackedEndPortalFrameBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PerturbedEyeItem
extends Item {
    public PerturbedEyeItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Level world = context.getLevel();
        BlockState blockState = world.getBlockState(blockPos = context.getClickedPos());
        if (blockState.is(Blocks.END_PORTAL_FRAME) || blockState.is((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get())) {
            BlockState targetBlockState;
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (blockState.is(Blocks.END_PORTAL_FRAME)) {
                Direction direction = (Direction)blockState.getValue((Property)EndPortalFrameBlock.FACING);
                boolean facingVertical = direction.equals((Object)Direction.EAST) || direction.equals((Object)Direction.WEST);
                targetBlockState = (BlockState)((BlockState)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get()).defaultBlockState().setValue(CrackedEndPortalFrameBlock.EYE_TYPE, (Comparable)((Object)CrackedEndPortalFrameBlock.EndPortalFrameEye.VANILLA_WITH_PERTURBED_EYE))).setValue((Property)CrackedEndPortalFrameBlock.FACING_VERTICAL, (Comparable)Boolean.valueOf(facingVertical));
            } else {
                boolean facingVertical = (Boolean)blockState.getValue((Property)CrackedEndPortalFrameBlock.FACING_VERTICAL);
                targetBlockState = (BlockState)((BlockState)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get()).defaultBlockState().setValue(CrackedEndPortalFrameBlock.EYE_TYPE, (Comparable)((Object)CrackedEndPortalFrameBlock.EndPortalFrameEye.WITH_PERTURBED_EYE))).setValue((Property)CrackedEndPortalFrameBlock.FACING_VERTICAL, (Comparable)Boolean.valueOf(facingVertical));
            }
            Block.pushEntitiesUp((BlockState)blockState, (BlockState)targetBlockState, (LevelAccessor)world, (BlockPos)blockPos);
            world.setBlock(blockPos, targetBlockState, 2);
            world.updateNeighbourForOutputSignal(blockPos, Blocks.END_PORTAL_FRAME);
            context.getItemInHand().shrink(1);
            world.levelEvent(1503, blockPos, 0);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.perturbed_eye.tooltip").withStyle(ChatFormatting.GRAY));
    }
}

