/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.item.LoomPatternProvider;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.inventories.CraftingTabletScreenHandler;
import earth.terrarium.pastel.items.tooltip.CraftingTabletTooltipData;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.registries.PastelBannerPatterns;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CraftingTabletItem
extends Item
implements LoomPatternProvider {
    private static final Component TITLE = Component.translatable((String)"item.pastel.crafting_tablet");

    public CraftingTabletItem(Item.Properties settings) {
        super(settings);
    }

    public static void setStoredRecipe(ItemStack craftingTabletItemStack, RecipeHolder<?> recipe) {
        craftingTabletItemStack.set(PastelDataComponentTypes.STORED_RECIPE, (Object)recipe.id());
    }

    public static void clearStoredRecipe(ItemStack craftingTabletItemStack) {
        craftingTabletItemStack.remove(PastelDataComponentTypes.STORED_RECIPE);
    }

    public static RecipeHolder<?> getStoredRecipe(Level world, ItemStack itemStack) {
        ResourceLocation id;
        if (world != null && (id = (ResourceLocation)itemStack.get(PastelDataComponentTypes.STORED_RECIPE)) != null) {
            return world.getRecipeManager().byKey(id).orElse(null);
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        RecipeHolder<?> storedRecipe = CraftingTabletItem.getStoredRecipe(world, itemStack);
        if (storedRecipe == null || user.isShiftKeyDown()) {
            if (world.isClientSide) {
                return InteractionResultHolder.success((Object)user.getItemInHand(hand));
            }
            user.openMenu(this.createScreenHandlerFactory(world, (ServerPlayer)user, itemStack));
            return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
        }
        if (storedRecipe.value() instanceof PedestalRecipe) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        if (CraftingTabletItem.tryCraftRecipe(user, storedRecipe.value(), world)) {
            if (world.isClientSide) {
                return InteractionResultHolder.success((Object)user.getItemInHand(hand));
            }
            return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
        }
        user.playSound(PastelSounds.USE_FAIL, 1.0f, 1.0f);
        return InteractionResultHolder.fail((Object)user.getItemInHand(hand));
    }

    public MenuProvider createScreenHandlerFactory(Level world, ServerPlayer serverPlayerEntity, ItemStack itemStack) {
        return new SimpleMenuProvider((syncId, inventory, player) -> new CraftingTabletScreenHandler(syncId, inventory, ContainerLevelAccess.create((Level)world, (BlockPos)serverPlayerEntity.blockPosition()), itemStack), TITLE);
    }

    public static boolean tryCraftRecipe(Player serverPlayerEntity, Recipe<?> recipe, Level world) {
        NonNullList ingredients = recipe.getIngredients();
        InvWrapper playerInventory = new InvWrapper((Container)serverPlayerEntity.getInventory());
        boolean hasInInventory = InventoryHelper.hasInInventory((List<Ingredient>)ingredients, (IItemHandlerModifiable)playerInventory);
        if (world.isClientSide) {
            return hasInInventory;
        }
        if (InventoryHelper.hasInInventory((List<Ingredient>)ingredients, (IItemHandlerModifiable)playerInventory)) {
            List<ItemStack> remainders = InventoryHelper.removeFromInventoryWithRemainders((List<Ingredient>)ingredients, (IItemHandlerModifiable)playerInventory);
            ItemStack craftingResult = recipe.getResultItem((HolderLookup.Provider)serverPlayerEntity.level().registryAccess()).copy();
            serverPlayerEntity.getInventory().placeItemBackInInventory(craftingResult);
            for (ItemStack remainder : remainders) {
                serverPlayerEntity.getInventory().placeItemBackInInventory(remainder);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        RecipeHolder<?> recipe = CraftingTabletItem.getStoredRecipe((Level)Minecraft.getInstance().level, stack);
        if (recipe == null) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.crafting_tablet.tooltip.no_recipe").withStyle(ChatFormatting.GRAY));
        } else {
            if (recipe.value() instanceof PedestalRecipe) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.crafting_tablet.tooltip.pedestal_recipe").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.crafting_tablet.tooltip.crafting_recipe").withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.translatable((String)"item.pastel.crafting_tablet.tooltip.shift_to_view_gui").withStyle(ChatFormatting.GRAY));
        }
        this.addBannerPatternProviderTooltip(tooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        Minecraft client = Minecraft.getInstance();
        RecipeHolder<?> storedRecipe = CraftingTabletItem.getStoredRecipe((Level)client.level, stack);
        if (storedRecipe != null) {
            return Optional.of(new CraftingTabletTooltipData(storedRecipe.value(), (Level)client.level));
        }
        return Optional.empty();
    }

    @Override
    public ResourceKey<BannerPattern> getPattern() {
        return PastelBannerPatterns.CRAFTING_TABLET;
    }
}

