/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.item_frame;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFrameItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class PastelItemFrameItem
extends ItemFrameItem {
    public PastelItemFrameItem(EntityType<? extends HangingEntity> entityType, Item.Properties settings) {
        super(entityType, settings);
    }

    public abstract ItemFrame getItemFrameEntity(Level var1, BlockPos var2, Direction var3);

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockPos blockPos2 = blockPos.relative(direction);
        Player playerEntity = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        if (playerEntity != null && !this.mayPlace(playerEntity, direction, itemStack, blockPos2)) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        ItemFrame invisibleItemFrameEntity = this.getItemFrameEntity(world, blockPos2, direction);
        CustomData nbtComponent = (CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!nbtComponent.isEmpty()) {
            EntityType.updateCustomEntityTag((Level)world, (Player)playerEntity, (Entity)invisibleItemFrameEntity, (CustomData)nbtComponent);
        }
        if (invisibleItemFrameEntity.survives()) {
            if (!world.isClientSide) {
                invisibleItemFrameEntity.playPlacementSound();
                world.gameEvent((Entity)playerEntity, (Holder)GameEvent.ENTITY_PLACE, blockPos);
                world.addFreshEntity((Entity)invisibleItemFrameEntity);
            }
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.CONSUME;
    }
}

