/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.food;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class AliasedTooltipItem
extends ItemNameBlockItem {
    private final List<MutableComponent> tooltipTexts = new ArrayList<MutableComponent>();

    public AliasedTooltipItem(Block block, Item.Properties settings, String tooltip) {
        super(block, settings);
        this.tooltipTexts.add(Component.translatable((String)tooltip));
    }

    public AliasedTooltipItem(Block block, Item.Properties settings, String[] tooltips) {
        super(block, settings);
        Arrays.stream(tooltips).map(Component::translatable).forEach(this.tooltipTexts::add);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        for (MutableComponent text : this.tooltipTexts) {
            tooltip.add((Component)text.withStyle(ChatFormatting.GRAY));
        }
    }
}

