/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.energy;

import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.storage.IndividualCappedInkStorage;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InkAssortmentItem
extends Item
implements InkStorageItem<IndividualCappedInkStorage>,
ExtendedItemBar {
    private final long maxEnergy;

    public InkAssortmentItem(Item.Properties settings, long maxEnergy) {
        super(settings);
        this.maxEnergy = maxEnergy;
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.ALWAYS;
    }

    @Override
    public IndividualCappedInkStorage getEnergyStorage(ItemStack itemStack) {
        InkStorageComponent storage = (InkStorageComponent)itemStack.get(PastelDataComponentTypes.INK_STORAGE);
        if (storage != null) {
            return new IndividualCappedInkStorage(storage.maxPerColor(), storage.storedEnergy());
        }
        return new IndividualCappedInkStorage(this.maxEnergy);
    }

    @Override
    public ItemStack getDefaultInstance() {
        return super.getDefaultInstance();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.getEnergyStorage(stack).addTooltip(tooltip);
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        IndividualCappedInkStorage storage = this.getEnergyStorage(stack);
        ArrayList<InkColor> colors = new ArrayList<InkColor>();
        if (player == null || storage.isEmpty()) {
            return ExtendedItemBar.PASS;
        }
        long time = player.level().getGameTime() % 864000L;
        for (InkColor inkColor : PastelRegistries.INK_COLOR) {
            if (storage.getEnergy(inkColor) <= 0L) continue;
            colors.add(inkColor);
        }
        int progress = Support.getSensiblePercent(storage.getCurrentTotal(), storage.getMaxTotal(), 14);
        if (colors.size() == 1) {
            InkColor color = (InkColor)colors.getFirst();
            return new ExtendedItemBar.BarSignature(1, 13, 14, progress, 1, ColorHelper.colorVecToRGB(color.getColorVec()) | 0xFF000000, 2, -16777216);
        }
        float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        InkColor curColor = (InkColor)colors.get((int)(time % (30L * (long)colors.size()) / 30L));
        InkColor nextColor = (InkColor)colors.get((int)((time % (30L * (long)colors.size()) / 30L + 1L) % (long)colors.size()));
        float blendFactor = ((float)time + delta) % 30.0f / 30.0f;
        int blendedColor = ColorHelper.interpolate(curColor.getTextColorVec(), nextColor.getTextColorVec(), blendFactor);
        return new ExtendedItemBar.BarSignature(1, 13, 14, progress, 1, blendedColor, 2, -16777216);
    }
}

