/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MysteriousLocketItem
extends Item {
    public MysteriousLocketItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack handStack;
        if (!world.isClientSide && (handStack = user.getItemInHand(hand)).has(PastelDataComponentTypes.SOCKETED)) {
            handStack.shrink(1);
            user.getInventory().placeItemBackInInventory(((Item)PastelItems.MYSTERIOUS_COMPASS.get()).getDefaultInstance());
            world.playSound(null, user.getX(), user.getY(), user.getZ(), PastelSounds.UNLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return super.use(world, user, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.mysterious_locket.tooltip").withStyle(ChatFormatting.GRAY));
        if (stack.has(PastelDataComponentTypes.SOCKETED)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.mysterious_locket.tooltip_socketed").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.mysterious_locket.tooltip_empty").withStyle(ChatFormatting.GRAY));
        }
    }
}

