/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MidnightAberrationItem
extends Item {
    private static final ResourceLocation MIDNIGHT_ABERRATION_CRUMBLING_ADVANCEMENT_ID = PastelCommon.locate("midgame/crumble_midnight_aberration");
    private static final String MIDNIGHT_ABERRATION_CRUMBLING_ADVANCEMENT_CRITERION = "have_midnight_aberration_crumble";
    private static final int CRUMBLING_GRACE_PERIOD_TICKS = 40;
    private static final String FIRST_INVENTORY_TICK_NBT = "first_inventory_tick";

    public MidnightAberrationItem(Item.Properties settings) {
        super(settings);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!world.isClientSide && world.getGameTime() % 20L == 0L && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (stack.has(PastelDataComponentTypes.STABLE)) {
                return;
            }
            if (!stack.has(PastelDataComponentTypes.TIMESTAMP)) {
                stack.set(PastelDataComponentTypes.TIMESTAMP, (Object)world.getGameTime());
                return;
            }
            long firstInventoryTick = (Long)stack.get(PastelDataComponentTypes.TIMESTAMP);
            if (world.getGameTime() < firstInventoryTick + 40L) {
                return;
            }
            if (world.random.nextFloat() < 0.2f) {
                stack.shrink(1);
                player.getInventory().placeItemBackInInventory(Items.GUNPOWDER.getDefaultInstance());
                world.playSound(null, (Entity)player, PastelSounds.MIDNIGHT_ABERRATION_CRUMBLING, SoundSource.PLAYERS, 0.5f, 1.0f);
                Support.grantAdvancementCriterion(player, MIDNIGHT_ABERRATION_CRUMBLING_ADVANCEMENT_ID, MIDNIGHT_ABERRATION_CRUMBLING_ADVANCEMENT_CRITERION);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (stack.has(PastelDataComponentTypes.STABLE)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.midnight_aberration.tooltip.stable"));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.has(PastelDataComponentTypes.TIMESTAMP) != newStack.has(PastelDataComponentTypes.TIMESTAMP);
    }

    public ItemStack getStableStack() {
        ItemStack stack = this.getDefaultInstance();
        stack.set(PastelDataComponentTypes.STABLE, (Object)Unit.INSTANCE);
        return stack;
    }
}

