/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.GuidebookItem;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CookbookItem
extends Item {
    public BookAddress bookAddress;
    private final int toolTipColor;

    public CookbookItem(Item.Properties settings, BookAddress bookAddress) {
        this(settings, bookAddress, -1);
    }

    public CookbookItem(Item.Properties settings, BookAddress bookAddress, int toolTipColor) {
        super(settings);
        this.bookAddress = bookAddress;
        this.toolTipColor = toolTipColor;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide) {
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)user.getItemInHand(hand));
        }
        try {
            this.openGuidebookPage(this.bookAddress);
        }
        catch (NullPointerException e) {
            PastelCommon.logError(user.getName().getString() + " used a CookbookItem to open the guidebook page " + String.valueOf(this.bookAddress) + " but it does not exist");
        }
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    private void openGuidebookPage(BookAddress address) {
        Object object = PastelItems.GUIDEBOOK.get();
        if (object instanceof GuidebookItem) {
            GuidebookItem guidebook = (GuidebookItem)object;
            guidebook.openGuidebook(address);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (this.toolTipColor == -1) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")).withStyle(ChatFormatting.GRAY));
            return;
        }
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")).withStyle(s -> s.withColor(this.toolTipColor)));
    }
}

