/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.items.food.DrinkItem;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;

public class ConcealingOilsItem
extends DrinkItem
implements InkPoweredPotionFillable {
    public static final int POISONED_COLOUR = 4002085;

    public ConcealingOilsItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (!InkPoweredPotionFillable.getEffects(stack).isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.concealing_oils.tooltip").withStyle(s -> s.applyFormat(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))));
        }
        this.appendPotionFillableTooltip(stack, tooltip, Component.translatable((String)"item.pastel.concealing_oils.when_poisoned"), true, context.tickRate());
    }

    public boolean overrideStackedOnOther(ItemStack oilsStack, Slot slot, ClickAction clickType, Player player) {
        if (clickType != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack stackToApplyTo = slot.getItem();
        if (!stackToApplyTo.has(DataComponents.FOOD)) {
            return false;
        }
        if (!this.isFull(oilsStack)) {
            return false;
        }
        if (this.tryApplyOil(oilsStack, stackToApplyTo, player)) {
            if (!player.getAbilities().instabuild) {
                oilsStack.shrink(1);
            }
            player.playSound(SoundEvents.BOTTLE_EMPTY, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean tryApplyOil(ItemStack oilsStack, ItemStack foodStack, Player user) {
        if (foodStack.getItem() instanceof DrinkItem) {
            return false;
        }
        if (foodStack.has(PastelDataComponentTypes.CONCEALED_EFFECT)) {
            return false;
        }
        InkPoweredStatusEffectInstance effect = InkPoweredPotionFillable.getEffects(oilsStack).getFirst();
        if (!InkPowered.tryDrainEnergy(user, effect.getInkCost().color(), effect.getInkCost().cost())) {
            return false;
        }
        FoodProperties foodComponent = (FoodProperties)foodStack.get(DataComponents.FOOD);
        if (foodComponent != null && foodComponent.effects().stream().map(FoodProperties.PossibleEffect::effect).anyMatch(e -> e.is(effect.getStatusEffectInstance().getEffect()))) {
            return false;
        }
        foodStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(user.getGameProfile()));
        foodStack.set(PastelDataComponentTypes.CONCEALED_EFFECT, (Object)effect.getStatusEffectInstance());
        return true;
    }

    @Override
    public int maxEffectCount() {
        return 1;
    }

    @Override
    public int maxEffectAmplifier() {
        return 3;
    }
}

