/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.blocks.potion_workshop.PotionWorkshopBlockEntity;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.DisabledSlot;
import earth.terrarium.pastel.inventories.slots.ReagentSlot;
import earth.terrarium.pastel.inventories.slots.StackFilterSlot;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PotionWorkshopScreenHandler
extends AbstractContainerMenu {
    protected final Level world;
    private final Container inventory;
    private final ContainerData propertyDelegate;

    public PotionWorkshopScreenHandler(int syncId, Inventory playerInventory) {
        this(PastelScreenHandlerTypes.POTION_WORKSHOP, syncId, playerInventory);
    }

    public PotionWorkshopScreenHandler(int syncId, Inventory playerInventory, PotionWorkshopBlockEntity potionWorkshopBlockEntity, ContainerData propertyDelegate) {
        this(PastelScreenHandlerTypes.POTION_WORKSHOP, syncId, playerInventory, potionWorkshopBlockEntity, propertyDelegate);
    }

    public PotionWorkshopScreenHandler(MenuType<?> type, int i, Inventory playerInventory) {
        this(type, i, playerInventory, (Container)new SimpleContainer(22), (ContainerData)new SimpleContainerData(3));
    }

    protected PotionWorkshopScreenHandler(MenuType<?> type, int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super(type, syncId);
        int k;
        int j;
        this.inventory = inventory;
        this.world = playerInventory.player.level();
        PotionWorkshopScreenHandler.checkContainerDataCount((ContainerData)propertyDelegate, (int)3);
        this.propertyDelegate = propertyDelegate;
        this.addDataSlots(propertyDelegate);
        PotionWorkshopScreenHandler.checkContainerSize((Container)inventory, (int)22);
        inventory.startOpen(playerInventory.player);
        this.addSlot(new StackFilterSlot(inventory, 0, 26, 85, (Item)PastelItems.MERMAIDS_GEM.get()));
        this.addSlot(new Slot(inventory, 1, 134, 41));
        this.addSlot(new Slot(inventory, 2, 26, 23));
        this.addSlot(new Slot(inventory, 3, 11, 42));
        this.addSlot(new Slot(inventory, 4, 41, 42));
        if (DatabankUtils.hasAdvancement((Player)playerInventory.player, (ResourceLocation)PastelAdvancements.FOURTH_BREWING_SLOT)) {
            this.addSlot(new ReagentSlot(inventory, 5, 51, 19));
            this.addSlot(new ReagentSlot(inventory, 6, 74, 19));
            this.addSlot(new ReagentSlot(inventory, 7, 97, 19));
            this.addSlot(new ReagentSlot(inventory, 8, 120, 19));
        } else {
            this.addSlot(new ReagentSlot(inventory, 5, 58, 19));
            this.addSlot(new ReagentSlot(inventory, 6, 85, 19));
            this.addSlot(new ReagentSlot(inventory, 7, 112, 19));
            this.addSlot(new DisabledSlot(inventory, 8, -2000, 19));
        }
        for (j = 0; j < 2; ++j) {
            for (k = 0; k < 6; ++k) {
                this.addSlot(new Slot(inventory, 9 + k + j * 6, 62 + k * 18, 67 + j * 18));
            }
        }
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 120 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 178));
        }
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (index < 9) {
                if (!this.moveItemStackTo(slotStack, 21, this.slots.size(), false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index < 21) {
                if (!this.moveItemStackTo(slotStack, 21, this.slots.size(), false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.moveItemStackTo(slotStack, 5, 9, false)) {
                    if (!slotStack.isEmpty()) {
                        this.moveItemStackTo(slotStack, 0, 5, false);
                    }
                    return ItemStack.EMPTY;
                }
                if (slotStack.isEmpty()) {
                    slot.setByPlayer(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
            }
        }
        return slotStackCopy;
    }

    public Container getInventory() {
        return this.inventory;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public int getBrewTime() {
        return this.propertyDelegate.get(0);
    }

    public int getMaxBrewTime() {
        return this.propertyDelegate.get(1);
    }

    public int getPotionColor() {
        return this.propertyDelegate.get(2);
    }
}

