/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.api.block.FilterConfigurable;
import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.ShadowSlot;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FilteringScreenHandler
extends AbstractContainerMenu {
    protected final Level world;
    protected FilterConfigurable.ExtendedData filterConfigurable;
    protected final Container filterInventory;
    protected final int rows;
    protected final int slotsPerRow;
    protected final int drawnSlots;

    public FilteringScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, (FilterConfigurable.ExtendedData)FilterConfigurable.ExtendedData.STREAM_CODEC.decode((Object)buf));
    }

    public FilteringScreenHandler(int syncId, Inventory playerInventory, FilterConfigurable.ExtendedData data) {
        this(PastelScreenHandlerTypes.FILTERING, syncId, playerInventory, handler -> new Tuple((Object)FilterConfigurable.getFilterInventoryFromItemsHandler(syncId, playerInventory, data.filterItems(), handler), (Object)new Integer[]{data.rows(), data.slotsPerRow(), data.drawnSlots()}));
        this.filterConfigurable = data;
    }

    protected FilteringScreenHandler(MenuType<?> type, int syncId, Inventory playerInventory, Function<AbstractContainerMenu, Tuple<Container, Integer[]>> filterInventoryFactory) {
        super(type, syncId);
        int j;
        this.world = playerInventory.player.level();
        Tuple<Container, Integer[]> pair = filterInventoryFactory.apply(this);
        this.filterInventory = (Container)pair.getA();
        Integer[] slotData = (Integer[])pair.getB();
        this.rows = slotData[0];
        this.slotsPerRow = slotData[1];
        this.drawnSlots = slotData[2];
        int nonObligatoryRows = this.rows - 1;
        int slotCount = Math.min(this.filterInventory.getContainerSize(), this.drawnSlots);
        int startX = 88 - (this.slotsPerRow + 1) * 9;
        int index = 0;
        block0: for (int i = 0; i < this.rows; ++i) {
            for (int k = 0; k < this.slotsPerRow; ++k) {
                if (index == slotCount) break block0;
                this.addSlot(new FilterSlot(this.filterInventory, index, startX + k * 23, 18 + i * 24));
                ++index;
            }
        }
        int i = 52 + (int)Math.round((double)nonObligatoryRows * 1.5) * 16;
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, j * 18 + i));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 58 + i));
        }
    }

    public int getRows() {
        return this.rows;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public Container getInventory() {
        return null;
    }

    public void removed(Player player) {
        super.removed(player);
    }

    protected class FilterSlot
    extends ShadowSlot {
        public FilterSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        @Override
        public boolean onClicked(ItemStack heldStack, ClickAction type, Player player) {
            if (!FilteringScreenHandler.this.world.isClientSide && FilteringScreenHandler.this.filterConfigurable != null) {
                FilteringScreenHandler.this.filterConfigurable.filterItems().set(this.getContainerSlot(), ItemReference.of(heldStack));
            }
            return super.onClicked(heldStack, type, player);
        }
    }
}

