/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;

public class CraftingTabletInventory
extends TransientCraftingContainer {
    private final NonNullList<ItemStack> gemAndOutputStacks = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    private final AbstractContainerMenu handler;

    public CraftingTabletInventory(AbstractContainerMenu handler) {
        super(handler, 3, 3);
        this.handler = handler;
    }

    public ItemStack getItem(int slot) {
        if (slot > 8) {
            return (ItemStack)this.gemAndOutputStacks.get(slot - 9);
        }
        return super.getItem(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (slot > 8) {
            return ContainerHelper.takeItem(this.gemAndOutputStacks, (int)(slot - 9));
        }
        return super.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        if (slot > 8) {
            ItemStack itemStack = ContainerHelper.removeItem(this.gemAndOutputStacks, (int)(slot - 9), (int)amount);
            if (!itemStack.isEmpty()) {
                this.handler.slotsChanged((Container)this);
            }
            return itemStack;
        }
        return super.removeItem(slot, amount);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot > 8) {
            this.gemAndOutputStacks.set(slot - 9, (Object)stack);
        } else {
            super.setItem(slot, stack);
        }
    }

    public void setChanged() {
    }

    public int getContainerSize() {
        return super.getContainerSize() + this.gemAndOutputStacks.size();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        super.clearContent();
        this.gemAndOutputStacks.clear();
    }

    public void fillStackedContents(StackedContents recipeMatcher) {
        super.fillStackedContents(recipeMatcher);
    }
}

