/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.inventories.CompactingChestScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CompactingChestScreen
extends AbstractContainerScreen<CompactingChestScreenHandler> {
    public static final ResourceLocation BACKGROUND = PastelCommon.locate("textures/gui/container/compacting_chest.png");

    public CompactingChestScreen(CompactingChestScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.imageHeight = 178;
    }

    protected void init() {
        super.init();
        this.setupInputFields();
    }

    protected void setupInputFields() {
        int x = (this.width - this.imageWidth) / 2 + 3;
        int y = (this.height - this.imageHeight) / 2 + 3;
        Button craftingModeButton = Button.builder((Component)Component.literal((String)"Mode"), this::craftingModeButtonPressed).size(16, 16).pos(x + 154, y + 6).build();
        this.addWidget((GuiEventListener)craftingModeButton);
    }

    private void craftingModeButtonPressed(Button buttonWidget) {
        ((CompactingChestScreenHandler)this.menu).toggleMode();
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        int titleX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int titleY = 6;
        Component title = this.title;
        int inventoryX = 8;
        int intInventoryY = 83;
        drawContext.drawString(this.font, title, titleX, titleY, 0x323232, false);
        drawContext.drawString(this.font, this.playerInventoryTitle, inventoryX, intInventoryY, 0x323232, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        drawContext.blit(BACKGROUND, x, y, 0, 0, this.imageWidth, this.imageHeight);
        drawContext.blit(BACKGROUND, x + 154, y + 6, 176, 16 * ((CompactingChestScreenHandler)this.menu).getCraftingMode().ordinal(), 16, 16);
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        if (mouseX > this.leftPos + 153 && mouseX < this.leftPos + 153 + 16 && mouseY > this.topPos + 5 && mouseY < this.topPos + 5 + 16) {
            drawContext.renderTooltip(this.font, (Component)Component.translatable((String)"block.pastel.compacting_chest.toggle_crafting_mode"), mouseX, mouseY);
        } else {
            this.renderTooltip(drawContext, mouseX, mouseY);
        }
    }
}

