/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.blocks.energy.ColorPickerBlockEntity;
import earth.terrarium.pastel.inventories.ColorPickerScreenHandler;
import earth.terrarium.pastel.inventories.widgets.ColorSelectionWidget;
import earth.terrarium.pastel.inventories.widgets.InkGaugeWidget;
import earth.terrarium.pastel.inventories.widgets.StackedInkMeterWidget;
import earth.terrarium.pastel.networking.c2s_payloads.InkColorSelectedC2SPayload;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class ColorPickerScreen
extends AbstractContainerScreen<ColorPickerScreenHandler>
implements Consumer<Optional<Holder<InkColor>>> {
    protected final ResourceLocation BACKGROUND = PastelCommon.locate("textures/gui/container/color_picker.png");
    protected ColorSelectionWidget colorSelectionWidget;
    protected InkGaugeWidget inkGaugeWidget;
    protected StackedInkMeterWidget inkMeterWidget;

    public ColorPickerScreen(ColorPickerScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        this.colorSelectionWidget = new ColorSelectionWidget(startX + 113, startY + 55, startX + 139, startY + 25, (Screen)this, ((ColorPickerScreenHandler)this.menu).getBlockEntity());
        this.inkGaugeWidget = new InkGaugeWidget(startX + 54, startY + 21, 42, 42, (Screen)this, ((ColorPickerScreenHandler)this.menu).getBlockEntity());
        this.inkMeterWidget = new StackedInkMeterWidget(startX + 100, startY + 21, 4, 40, (Screen)this, ((ColorPickerScreenHandler)this.menu).getBlockEntity());
        this.colorSelectionWidget.setChangedListener(this);
        this.addWidget((GuiEventListener)this.colorSelectionWidget);
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        int titleX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int titleY = 6;
        Component title = this.title;
        drawContext.drawString(this.font, title.getVisualOrderText(), titleX, titleY, 0x323232, false);
        drawContext.drawString(this.font, this.playerInventoryTitle, 8, 74, 0x323232, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        drawContext.blit(this.BACKGROUND, startX, startY, 0, 0, this.imageWidth, this.imageHeight);
        this.inkGaugeWidget.draw(drawContext);
        this.inkMeterWidget.draw(drawContext);
        this.colorSelectionWidget.render(drawContext, mouseX, mouseY, delta);
        drawContext.blit(this.BACKGROUND, startX + 52, startY + 18, 176, 0, 46, 46);
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics drawContext, int x, int y) {
        if (this.inkGaugeWidget.isMouseOver(x, y)) {
            this.inkGaugeWidget.drawMouseoverTooltip(drawContext, x, y);
        } else if (this.inkMeterWidget.isMouseOver(x, y)) {
            this.inkMeterWidget.drawMouseoverTooltip(drawContext, x, y);
        } else if (this.colorSelectionWidget.isMouseOver(x, y)) {
            this.colorSelectionWidget.drawMouseoverTooltip(drawContext, x, y);
        } else {
            super.renderTooltip(drawContext, x, y);
        }
    }

    @Override
    public void accept(Optional<Holder<InkColor>> inkColor) {
        ColorPickerBlockEntity colorPicker = ((ColorPickerScreenHandler)this.menu).getBlockEntity();
        colorPicker.setSelectedColor(inkColor);
        PacketDistributor.sendToServer((CustomPacketPayload)new InkColorSelectedC2SPayload(inkColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

