/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.api.item.ItemReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;

public enum AutoCraftingMode {
    X1(1, 1),
    X2(2, 2),
    X3(3, 3);

    private static final Map<AutoCraftingMode, Map<ResourceLocation, ItemReference>> CACHE;
    private final int width;
    private final int height;

    private AutoCraftingMode(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.width * this.height;
    }

    public AutoCraftingMode next() {
        return AutoCraftingMode.values()[(this.ordinal() + 1) % AutoCraftingMode.values().length];
    }

    public CraftingInput.Positioned createRecipeInput(ItemStack variant) {
        ItemStack stack = variant;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            inputs.add(stack);
        }
        return CraftingInput.ofPositioned((int)this.width, (int)this.height, inputs);
    }

    public static Map<ResourceLocation, ItemReference> getCache(AutoCraftingMode mode) {
        return CACHE.computeIfAbsent(mode, m -> new HashMap());
    }

    public static void clearCache() {
        CACHE.clear();
    }

    static {
        CACHE = new EnumMap<AutoCraftingMode, Map<ResourceLocation, ItemReference>>(AutoCraftingMode.class);
    }
}

