/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.render;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class TooltipHelper {
    public static void addFoodComponentEffectTooltip(ItemStack stack, List<Either<FormattedText, TooltipComponent>> tooltip, float updateTickRate) {
        FoodProperties foodComponent = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodComponent != null) {
            TooltipHelper.buildEffectTooltipWithChance(tooltip, foodComponent.effects(), stack.getUseAnimation() == UseAnim.DRINK ? Component.translatable((String)"pastel.food.whenDrunk") : Component.translatable((String)"pastel.food.whenEaten"), updateTickRate);
        }
    }

    public static void buildEffectTooltipWithChance(List<Either<FormattedText, TooltipComponent>> tooltip, List<FoodProperties.PossibleEffect> entries, MutableComponent attributeModifierText, float updateTickRate) {
        if (entries.isEmpty()) {
            return;
        }
        ArrayList modifiersList = Lists.newArrayList();
        for (FoodProperties.PossibleEffect entry : entries) {
            MobEffectInstance statusEffectInstance = entry.effect();
            float chance = entry.probability();
            MutableComponent translatableText = Component.translatable((String)statusEffectInstance.getDescriptionId());
            Holder statusEffect = statusEffectInstance.getEffect();
            ((MobEffect)statusEffect.value()).createModifiers(statusEffectInstance.getAmplifier(), (attribute, modifier) -> modifiersList.add(new Pair((Object)((Attribute)attribute.value()), modifier)));
            if (statusEffectInstance.getAmplifier() > 0) {
                translatableText = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{translatableText, Component.translatable((String)("potion.potency." + statusEffectInstance.getAmplifier()))});
            }
            if (statusEffectInstance.getDuration() > 20) {
                translatableText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{translatableText, StringUtil.formatTickDuration((int)statusEffectInstance.getDuration(), (float)updateTickRate)});
            }
            if (chance < 1.0f) {
                translatableText = Component.translatable((String)"pastel.food.withChance", (Object[])new Object[]{translatableText, Math.round(chance * 100.0f)});
            }
            tooltip.add((Either<FormattedText, TooltipComponent>)Either.left((Object)translatableText.withStyle(((MobEffect)statusEffect.value()).getCategory().getTooltipFormatting())));
        }
        if (!modifiersList.isEmpty()) {
            tooltip.add((Either<FormattedText, TooltipComponent>)Either.left((Object)Component.empty()));
            tooltip.add((Either<FormattedText, TooltipComponent>)Either.left((Object)attributeModifierText.withStyle(ChatFormatting.DARK_PURPLE)));
            for (Pair pair : modifiersList) {
                AttributeModifier modifier2 = (AttributeModifier)pair.getSecond();
                double d = modifier2.amount();
                double e = modifier2.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && modifier2.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? modifier2.amount() : modifier2.amount() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Either<FormattedText, TooltipComponent>)Either.left((Object)Component.translatable((String)("attribute.modifier.plus." + modifier2.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE)));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Either<FormattedText, TooltipComponent>)Either.left((Object)Component.translatable((String)("attribute.modifier.take." + modifier2.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e *= -1.0), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED)));
            }
        }
    }
}

