/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public abstract class EventQueue<D>
implements GameEventListener {
    protected final PositionSource positionSource;
    protected final int range;
    protected final Callback<D> callback;
    protected final Map<D, Integer> eventQueue;

    public EventQueue(PositionSource positionSource, int range, Callback<D> listener) {
        this.positionSource = positionSource;
        this.range = range;
        this.callback = listener;
        this.eventQueue = new HashMap<D, Integer>();
    }

    public void tick(Level world) {
        for (D key : new HashSet<D>(this.eventQueue.keySet())) {
            Integer tickCounter = this.eventQueue.get(key);
            if (tickCounter >= 1) {
                this.eventQueue.put(key, tickCounter - 1);
                continue;
            }
            this.callback.triggerEvent(world, this, key);
            this.eventQueue.remove(key);
        }
    }

    public PositionSource getListenerSource() {
        return this.positionSource;
    }

    public int getListenerRadius() {
        return this.range;
    }

    public int getQueuedEventCount() {
        return this.eventQueue.size();
    }

    public boolean handleGameEvent(ServerLevel world, Holder<GameEvent> event, GameEvent.Context emitter, Vec3 emitterPos) {
        Optional positionSourcePosOptional = this.positionSource.getPosition((Level)world);
        if (positionSourcePosOptional.isEmpty()) {
            return false;
        }
        if (!this.callback.canAcceptEvent((Level)world, this, new GameEvent.ListenerInfo(event, emitterPos, emitter, (GameEventListener)this, (Vec3)positionSourcePosOptional.get()), (Vec3)positionSourcePosOptional.get())) {
            return false;
        }
        this.acceptEvent((Level)world, new GameEvent.ListenerInfo(event, emitterPos, emitter, (GameEventListener)this, (Vec3)positionSourcePosOptional.get()), (Vec3)positionSourcePosOptional.get());
        return true;
    }

    protected abstract void acceptEvent(Level var1, GameEvent.ListenerInfo var2, Vec3 var3);

    protected void schedule(D object, int delay) {
        this.eventQueue.put(object, delay);
    }

    public static interface Callback<D> {
        public boolean canAcceptEvent(Level var1, GameEventListener var2, GameEvent.ListenerInfo var3, Vec3 var4);

        public void triggerEvent(Level var1, GameEventListener var2, D var3);
    }
}

