/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.blocks.shooting_star.ShootingStar;
import earth.terrarium.pastel.blocks.shooting_star.ShootingStarItem;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.networking.s2c_payloads.PlayShootingStarParticlesPayload;
import earth.terrarium.pastel.particle.effect.DynamicParticleEffect;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLootTables;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ShootingStarEntity
extends Entity {
    private static final EntityDataAccessor<Integer> SHOOTING_STAR_TYPE = SynchedEntityData.defineId(ShootingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> PLAYER_PLACED = SynchedEntityData.defineId(ShootingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HARDENED = SynchedEntityData.defineId(ShootingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected final float hoverHeight = (float)(Math.random() * Math.PI * 2.0);
    protected long age;
    protected int availableHits;
    protected int lastCollisionCount;

    public ShootingStarEntity(EntityType<? extends ShootingStarEntity> entityType, Level world) {
        super(entityType, world);
        this.availableHits = 5 + world.random.nextInt(3);
        this.lastCollisionCount = 0;
    }

    public ShootingStarEntity(Level world, double x, double y, double z, ShootingStar.Variant type, boolean playerPlaced, int availableHits, boolean hardened) {
        this((EntityType<? extends ShootingStarEntity>)((EntityType)PastelEntityTypes.SHOOTING_STAR.get()), world);
        this.setPos(x, y, z);
        this.setYRot(this.random.nextFloat() * 360.0f);
        this.setShootingStarType(type, playerPlaced, availableHits, hardened);
        this.lastCollisionCount = 0;
    }

    public static boolean canCollide(Entity entity, @NotNull Entity other) {
        return (other.canBeCollidedWith() || other.isPushable()) && !entity.isPassengerOfSameVehicle(other);
    }

    public static void playHitParticles(Level world, double x, double y, double z, ShootingStar.Variant type, int amount) {
        RandomSource random = world.random;
        for (int i = 0; i < amount; ++i) {
            float randomScale = 0.5f + random.nextFloat();
            int randomLifetime = 10 + random.nextInt(20);
            DynamicParticleEffect particleEffect = new DynamicParticleEffect(0.98f, type.getRandomParticleColor(random), randomScale, randomLifetime, false, true, true);
            world.addParticle((ParticleOptions)particleEffect, x, y, z, 0.35 - (double)random.nextFloat() * 0.7, (double)random.nextFloat() * 0.7, 0.35 - (double)random.nextFloat() * 0.7);
        }
    }

    public boolean canCollideWith(Entity other) {
        return ShootingStarEntity.canCollide(this, other);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean isPushable() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SHOOTING_STAR_TYPE, (Object)ShootingStar.Variant.COLORFUL.ordinal());
        builder.define(PLAYER_PLACED, (Object)false);
        builder.define(HARDENED, (Object)false);
    }

    public void tick() {
        super.tick();
        boolean wasOnGround = this.onGround();
        double previousXVelocity = this.getDeltaMovement().x();
        double previousYVelocity = this.getDeltaMovement().y();
        double previousZVelocity = this.getDeltaMovement().z();
        Level world = this.level();
        if (world.isClientSide) {
            this.noPhysics = false;
        } else {
            boolean bl = this.noPhysics = !this.level().noCollision((Entity)this, this.getBoundingBox().deflate(1.0E-7));
            if (this.noPhysics) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
            }
        }
        if (!this.isNoGravity()) {
            double d = this.isInWater() ? -0.005 : -0.04;
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, d, 0.0));
            if (!this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        List<Entity> collidingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.25, 0.334, 0.25));
        collidingEntities = collidingEntities.stream().filter(entity -> !(entity instanceof ShootingStarEntity) && entity.isPushable()).toList();
        boolean spawnLoot = false;
        boolean playerPlaced = (Boolean)this.entityData.get(PLAYER_PLACED);
        boolean hardened = (Boolean)this.entityData.get(HARDENED);
        if (this.onGround() && !wasOnGround) {
            this.push(0.0, -previousYVelocity * 0.9, 0.0);
            collidingEntities.forEach(entity -> entity.move(MoverType.SHULKER_BOX, this.getDeltaMovement().multiply(0.0, 1.0, 0.0)));
        }
        if (Math.signum(this.getDeltaMovement().x) != Math.signum(previousXVelocity)) {
            this.push(-previousXVelocity * 0.6, 0.0, 0.0);
            if (!hardened && Math.abs(previousXVelocity) > 0.5) {
                spawnLoot = true;
            }
        }
        if (Math.signum(this.getDeltaMovement().z) != Math.signum(previousZVelocity)) {
            this.push(0.0, 0.0, -previousZVelocity * 0.6);
            if (!hardened && !spawnLoot && Math.abs(previousZVelocity) > 0.5) {
                spawnLoot = true;
            }
        }
        collidingEntities.forEach(entity -> {
            if (entity.getY() >= this.getBoundingBox().maxY) {
                entity.fallDistance = 0.0f;
                if (this.isPickable()) {
                    entity.setPos(entity.position().x, this.getBoundingBox().maxY, entity.position().z);
                }
                entity.move(MoverType.SHULKER_BOX, this.getDeltaMovement());
                entity.setOnGround(true);
            }
        });
        if (world.isClientSide) {
            if (!playerPlaced && !hardened) {
                if (this.onGround()) {
                    if (world.random.nextInt(10) == 0) {
                        this.playGroundParticles();
                    }
                } else if (world.random.nextBoolean()) {
                    this.playFallingParticles();
                }
            }
        } else {
            List otherEntities;
            ++this.age;
            if (this.age > 6000L && !playerPlaced && !hardened) {
                this.discard();
                return;
            }
            this.checkInsideBlocks();
            if (spawnLoot && this.age > 1L) {
                ++this.lastCollisionCount;
                if (this.lastCollisionCount > 8) {
                    --this.availableHits;
                    if (this.availableHits > 0) {
                        ItemStack shootingStarStack = ShootingStarItem.getWithRemainingHits((ShootingStarItem)this.asItem(), this.availableHits, (boolean)((Boolean)this.entityData.get(HARDENED)));
                        itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), shootingStarStack);
                        this.level().addFreshEntity((Entity)itemEntity);
                    } else {
                        ItemStack starFragmentStack = ((Item)PastelItems.STAR_FRAGMENT.get()).getDefaultInstance();
                        itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), starFragmentStack);
                        this.level().addFreshEntity((Entity)itemEntity);
                    }
                    this.discard();
                } else {
                    List<ItemStack> loot = this.getLoot((ServerLevel)this.level(), PastelLootTables.SHOOTING_STAR_BOUNCE);
                    for (ItemStack itemStack : loot) {
                        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemStack);
                        this.level().addFreshEntity((Entity)itemEntity);
                    }
                    PlayShootingStarParticlesPayload.sendPlayShootingStarParticles(this);
                    this.level().playSound(null, this.blockPosition(), PastelSounds.SHOOTING_STAR_CRACKER, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (!hardened && !wasOnGround && this.onGround() && previousYVelocity < -0.5) {
                PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity((ServerLevel)this.level(), this.position(), (ParticleOptions)ParticleTypes.EXPLOSION, 1, Vec3.ZERO);
                if (!spawnLoot) {
                    PlayShootingStarParticlesPayload.sendPlayShootingStarParticles(this);
                    this.level().playSound(null, this.blockPosition(), PastelSounds.SHOOTING_STAR_CRACKER, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (!(otherEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2, -0.01, 0.2), EntitySelector.pushableBy((Entity)this))).isEmpty()) {
                for (Entity d : otherEntities) {
                    this.push(d);
                }
            }
            this.updateInWaterStateAndDoFluidPushing();
        }
    }

    public void playerTouch(Player player) {
        if (!this.level().isClientSide() && !((Boolean)this.entityData.get(HARDENED)).booleanValue() && !this.onGround() && this.getDeltaMovement().y() < -0.5) {
            this.level().playSound(null, (double)this.blockPosition().getX(), (double)this.blockPosition().getY(), (double)this.blockPosition().getZ(), PastelSounds.SHOOTING_STAR_CRACKER, SoundSource.PLAYERS, 1.5f + this.random.nextFloat() * 0.4f, 0.8f + this.random.nextFloat() * 0.4f);
            PlayShootingStarParticlesPayload.sendPlayShootingStarParticles(this);
            player.hurt(PastelDamageTypes.shootingStar(this.level()), 18.0f);
            ItemStack itemStack = this.getShootingStarType().getBlock().asItem().getDefaultInstance();
            int i = itemStack.getCount();
            player.getInventory().placeItemBackInInventory(itemStack);
            Support.grantAdvancementCriterion((ServerPlayer)player, "catch_shooting_star", "catch");
            player.awardStat(Stats.ITEM_PICKED_UP.get((Object)itemStack.getItem()), i);
            this.discard();
        }
    }

    public void push(Entity entity) {
        if (entity.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(entity);
        }
    }

    public Item asItem() {
        return this.getShootingStarType().getBlock().asItem();
    }

    public void playGroundParticles() {
        float randomScale = 0.5f + this.random.nextFloat();
        int randomLifetime = 30 + this.random.nextInt(20);
        DynamicParticleEffect particleEffect = new DynamicParticleEffect(0.05f, this.getShootingStarType().getRandomParticleColor(this.random), randomScale, randomLifetime, false, true, true);
        this.level().addParticle((ParticleOptions)particleEffect, this.getX(), this.getEyeY(), this.getZ(), 0.1 - (double)this.random.nextFloat() * 0.2, 0.4 + (double)this.random.nextFloat() * 0.2, 0.1 - (double)this.random.nextFloat() * 0.2);
    }

    public void playFallingParticles() {
        float randomScale = this.random.nextFloat() * 0.4f + 0.7f;
        DynamicParticleEffect particleEffect = new DynamicParticleEffect((float)((this.random.nextDouble() - 0.5) * (double)0.05f - 0.125), this.getShootingStarType().getRandomParticleColor(this.random), randomScale, 120, false, true, true);
        this.level().addParticle((ParticleOptions)particleEffect, this.getX(), this.getEyeY(), this.getZ(), 0.2 - (double)this.random.nextFloat() * 0.4, 0.1, 0.2 - (double)this.random.nextFloat() * 0.4);
    }

    public void playHitParticles() {
        ShootingStarEntity.playHitParticles(this.level(), this.getX(), this.getEyeY(), this.getZ(), this.getShootingStarType(), 25);
    }

    public void doPlayerHitEffectsAndLoot(ServerLevel serverWorld, ServerPlayer serverPlayerEntity) {
        @NotNull ResourceKey<LootTable> lootTableKey = ShootingStar.Variant.getLootTable((Integer)this.entityData.get(SHOOTING_STAR_TYPE));
        List<ItemStack> loot = this.getLoot(serverWorld, serverPlayerEntity, lootTableKey);
        for (ItemStack itemStack : loot) {
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemStack);
            this.level().addFreshEntity((Entity)itemEntity);
        }
        PlayShootingStarParticlesPayload.sendPlayShootingStarParticles(this);
        this.level().playSound(null, (double)this.blockPosition().getX(), (double)this.blockPosition().getY(), (double)this.blockPosition().getZ(), PastelSounds.SHOOTING_STAR_CRACKER, SoundSource.PLAYERS, 1.5f + this.random.nextFloat() * 0.4f, 0.8f + this.random.nextFloat() * 0.4f);
    }

    public List<ItemStack> getLoot(ServerLevel serverWorld, ServerPlayer serverPlayerEntity, ResourceKey<LootTable> lootTableKey) {
        LootTable lootTable = serverWorld.getServer().reloadableRegistries().getLootTable(lootTableKey);
        return lootTable.getRandomItems(new LootParams.Builder(serverWorld).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.blockPosition())).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverPlayerEntity.level().damageSources().playerAttack((Player)serverPlayerEntity)).withOptionalParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)serverPlayerEntity).create(LootContextParamSets.ENTITY));
    }

    public List<ItemStack> getLoot(ServerLevel serverWorld, ResourceKey<LootTable> lootTableKey) {
        LootTable lootTable = serverWorld.getServer().reloadableRegistries().getLootTable(lootTableKey);
        return lootTable.getRandomItems(new LootParams.Builder(serverWorld).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.blockPosition())).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverWorld.damageSources().generic()).create(LootContextParamSets.ENTITY));
    }

    public Component getName() {
        Component text = this.getCustomName();
        return text != null ? text : this.asItem().getDescription();
    }

    public boolean skipAttackInteraction(Entity attacker) {
        if (!this.isRemoved()) {
            if (!this.level().isClientSide()) {
                if (!((Boolean)this.entityData.get(HARDENED)).booleanValue()) {
                    this.age = 1L;
                    --this.availableHits;
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        if (attacker instanceof ServerPlayer) {
                            ServerPlayer serverPlayerEntity = (ServerPlayer)attacker;
                            this.doPlayerHitEffectsAndLoot(serverWorld, serverPlayerEntity);
                            this.lastCollisionCount = 0;
                        }
                    }
                    if (this.availableHits <= 0) {
                        PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity((ServerLevel)this.level(), this.position(), (ParticleOptions)ParticleTypes.EXPLOSION, 1, Vec3.ZERO);
                        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), ((Item)PastelItems.STAR_FRAGMENT.get()).getDefaultInstance());
                        itemEntity.push(0.0, 0.15, 0.0);
                        this.level().addFreshEntity((Entity)itemEntity);
                        this.discard();
                        return true;
                    }
                }
                this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, attacker);
            }
            double attackerOffsetX = this.getX() - attacker.getX();
            double attackerOffsetZ = this.getZ() - attacker.getZ();
            double mod = Math.max(attackerOffsetX, attackerOffsetZ);
            this.push(attackerOffsetX / mod * 0.75, 0.25, attackerOffsetZ / mod * 0.75);
            List<Entity> collidingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.25, 0.334, 0.25));
            collidingEntities = collidingEntities.stream().filter(entity -> !(entity instanceof ShootingStarEntity)).toList();
            collidingEntities.forEach(entity -> {
                if (entity.getY() >= this.getBoundingBox().maxY) {
                    entity.fallDistance = 0.0f;
                    if (this.isPickable()) {
                        entity.setPos(entity.position().x, this.getBoundingBox().maxY, entity.position().z);
                    }
                    entity.move(MoverType.SHULKER_BOX, this.getDeltaMovement());
                    entity.setOnGround(true);
                }
            });
            this.markHurt();
        }
        return false;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource damageSource) {
        if (damageSource.is(DamageTypes.FALLING_ANVIL) || damageSource.is(PastelDamageTypes.FLOATBLOCK)) {
            return false;
        }
        return damageSource.is(DamageTypeTags.IS_FIRE) || super.isInvulnerableTo(damageSource);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (amount > 5.0f && (damageSource.is(DamageTypes.FALLING_ANVIL) || damageSource.is(PastelDamageTypes.FLOATBLOCK))) {
            this.playHitParticles();
            ItemStack starFragmentStack = ((Item)PastelItems.STAR_FRAGMENT.get()).getDefaultInstance();
            starFragmentStack.setCount(2);
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), starFragmentStack);
            this.level().addFreshEntity((Entity)itemEntity);
            this.discard();
            return true;
        }
        this.markHurt();
        return false;
    }

    public ShootingStar.Variant getShootingStarType() {
        return ShootingStar.Variant.getType((Integer)this.getEntityData().get(SHOOTING_STAR_TYPE));
    }

    private void setShootingStarType(@NotNull ShootingStar.Variant type, boolean playerPlaced, int availableHits, boolean hardened) {
        this.getEntityData().set(SHOOTING_STAR_TYPE, (Object)type.ordinal());
        this.getEntityData().set(PLAYER_PLACED, (Object)playerPlaced);
        this.getEntityData().set(HARDENED, (Object)hardened);
        this.availableHits = availableHits;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putLong("Age", (long)((short)this.age));
        tag.putString("Variant", this.getShootingStarType().getName());
        tag.putInt("LastCollisionCount", this.lastCollisionCount);
        tag.putBoolean("PlayerPlaced", ((Boolean)this.entityData.get(PLAYER_PLACED)).booleanValue());
        tag.putBoolean("Hardened", ((Boolean)this.entityData.get(HARDENED)).booleanValue());
        tag.putInt("AvailableHits", this.availableHits);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        this.age = tag.getLong("Age");
        if (tag.contains("LastCollisionCount", 99)) {
            this.lastCollisionCount = tag.getInt("LastCollisionCount");
        }
        if (tag.contains("PlayerPlaced") && tag.contains("Hardened") && tag.contains("AvailableHits", 99) && tag.contains("Variant", 8)) {
            boolean playerPlaced = tag.getBoolean("PlayerPlaced");
            int availableHits = tag.getInt("AvailableHits");
            boolean hardened = tag.getBoolean("Hardened");
            this.setShootingStarType(ShootingStar.Variant.getType(tag.getString("Variant")), playerPlaced, availableHits, hardened);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.level().isClientSide() && player.isShiftKeyDown()) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.getInventory().placeItemBackInInventory(ShootingStarItem.getWithRemainingHits((ShootingStarItem)this.asItem(), this.availableHits, (boolean)((Boolean)this.entityData.get(HARDENED))));
            this.discard();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public ItemStack getPickResult() {
        return ShootingStarItem.getWithRemainingHits((ShootingStarItem)this.asItem(), this.availableHits, (boolean)((Boolean)this.entityData.get(HARDENED)));
    }

    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }
}

