/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.deeper_down;

import earth.terrarium.pastel.deeper_down.EnvironmentalData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Vector3f;

public record EnvironmentalOverride(Predicate<Entity> predicate, ColorData color, EnvironmentalData dataOverride, int priority) {
    private static final List<EnvironmentalOverride> OVERRIDES = new ArrayList<EnvironmentalOverride>();
    public static final ColorData BLANK = new ColorData(new Vector3f(), 0.0f);
    public static final EnvironmentalOverride INACTIVE = new EnvironmentalOverride(null, BLANK, EnvironmentalData.NOOP, -999);
    static final EnvironmentalData NOOP = new EnvironmentalData(0.0f, 0.0f, 0.0f, 0.0f);

    public EnvironmentalOverride(Predicate<Entity> predicate, ColorData data, int priority) {
        this(predicate, data, EnvironmentalData.NOOP, priority);
    }

    public EnvironmentalOverride(Predicate<Entity> predicate, EnvironmentalData dataOverride, int priority) {
        this(predicate, BLANK, dataOverride, priority);
    }

    public static EnvironmentalOverride fromArray(float[] override) {
        return new EnvironmentalOverride(null, new ColorData(new Vector3f(override[1], override[2], override[3]), override[0]), new EnvironmentalData(override[4], override[5], override[6], override[7]), -999);
    }

    public float[] asArray() {
        Vector3f color = this.color().colorMod;
        return ArrayUtils.addAll((float[])new float[]{this.color().blend, color.x, color.y, color.z}, (float[])this.dataOverride.asArray());
    }

    public static EnvironmentalOverride get(Entity camera) {
        EnvironmentalOverride effect = INACTIVE;
        for (EnvironmentalOverride override : OVERRIDES) {
            if (!override.predicate.test(camera)) continue;
            if (effect == INACTIVE) {
                effect = override;
                continue;
            }
            if (override.priority <= effect.priority) continue;
            effect = override;
        }
        return effect;
    }

    public static void register(EnvironmentalOverride override) {
        OVERRIDES.add(override);
    }

    public record ColorData(Vector3f colorMod, float blend) {
        public boolean isBlank() {
            return this == BLANK;
        }
    }
}

