/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.deeper_down;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;

public record ColorGrading(float saturation, float rubedo, float colorTemperature, float threshold, float bloom) {
    public static final float[] GRADING_OUT = new float[5];
    public static ColorGrading DEFAULT = new ColorGrading(1.0f, 0.0f, 65.0f, 0.85f, 0.35f);
    public static final Codec<ColorGrading> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("saturation").forGetter(ColorGrading::saturation), (App)Codec.FLOAT.fieldOf("rubedo").forGetter(ColorGrading::rubedo), (App)Codec.FLOAT.fieldOf("temperature").forGetter(ColorGrading::colorTemperature), (App)Codec.FLOAT.fieldOf("threshold").forGetter(ColorGrading::threshold), (App)Codec.FLOAT.fieldOf("bloom").forGetter(ColorGrading::bloom)).apply((Applicative)i, ColorGrading::new));

    public static void update(float[] old, float[] current, float delta) {
        for (int i = 0; i < 5; ++i) {
            ColorGrading.GRADING_OUT[i] = Mth.lerp((float)delta, (float)old[i], (float)current[i]);
        }
    }

    public float[] asArray() {
        return new float[]{this.saturation, this.rubedo, this.colorTemperature, this.threshold, this.bloom};
    }
}

